/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support.feature;

import com.google.common.collect.Sets;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.FabricationResourcePack;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ResourcePackFeature
implements Feature,
RepositorySource {
    private final String configKey;
    private final String path;
    public boolean active = false;

    public ResourcePackFeature(String path) {
        this.configKey = "*." + path;
        this.path = path;
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
            this.initClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initClient() {
        HashSet providers = FabRefl.getProviders(Minecraft.m_91087_().m_91099_());
        try {
            providers.add((RepositorySource)this);
        }
        catch (UnsupportedOperationException e) {
            FabLog.info("Injecting mutable resource pack provider set, as no-one else has yet.");
            providers = Sets.newHashSet(providers);
            providers.add(this);
            FabRefl.setProviders(Minecraft.m_91087_().m_91099_(), providers);
        }
    }

    public void m_7686_(Consumer<Pack> consumer, Pack.PackConstructor factory) {
        if (this.active) {
            Supplier<PackResources> f = () -> new FabricationResourcePack(this.path);
            consumer.accept(factory.m_143873_(MixinConfigPlugin.MOD_NAME + " " + this.path, (Component)Component.m_237113_((String)("Internal " + MixinConfigPlugin.MOD_NAME + " resources")), true, f, new PackMetadataSection((Component)Component.m_237113_((String)("Internal " + MixinConfigPlugin.MOD_NAME + " resources")), 9), Pack.Position.TOP, PackSource.f_10528_));
        }
    }

    @Override
    public void apply() {
        this.active = true;
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
            this.reloadClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void reloadClient() {
        if (Minecraft.m_91087_().m_91098_() != null) {
            Minecraft.m_91087_().m_91391_();
        }
    }

    @Override
    public boolean undo() {
        this.active = false;
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
            this.reloadClient();
        }
        return true;
    }

    @Override
    public String getConfigKey() {
        return this.configKey;
    }
}

