/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support.injection;

import com.google.common.base.Joiner;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.injection.FabRefMap;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.asm.MethodNodeEx;
import org.spongepowered.asm.util.asm.MixinVerifier;

public class FabInjector {
    public static Function<ClassInfo, Set<IMixinInfo>> getMixinInfoFromClassInfo = i -> Collections.emptySet();
    public static Function<IMixinInfo, IReferenceMapper> getMixinReferenceMapper;
    public static final Set<String> dejavu;

    public static Map<String, String> getMixinRedirects(String className) {
        ClassInfo ci = ClassInfo.fromCache((String)className);
        if (ci == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> discoveredRedirects = new HashMap<String, String>();
        for (IMixinInfo inf : getMixinInfoFromClassInfo.apply(ci)) {
            if (inf == null) continue;
            ClassNode cn = inf.getClassNode(0);
            if (cn.methods == null) continue;
            for (MethodNode mth : cn.methods) {
                if (mth.visibleAnnotations == null) continue;
                for (AnnotationNode annotation : mth.visibleAnnotations) {
                    String mapped;
                    Object target;
                    Object atNode;
                    int at;
                    if (annotation == null || !"Lorg/spongepowered/asm/mixin/injection/Redirect;".equals(annotation.desc) || (at = annotation.values.indexOf("at")) == -1 || at >= annotation.values.size() || !((atNode = annotation.values.get(at + 1)) instanceof AnnotationNode)) continue;
                    AnnotationNode an = (AnnotationNode)atNode;
                    int ani = an.values.indexOf("target");
                    if (ani == -1 || ani >= an.values.size() || !((target = an.values.get(ani + 1)) instanceof String)) continue;
                    IReferenceMapper mapper = getMixinReferenceMapper.apply(inf);
                    if (mapper != null && (mapped = mapper.remap(inf.getClassName().replace('.', '/'), (String)target)) != null) {
                        target = mapped;
                    }
                    discoveredRedirects.put(mth.name, (String)target);
                }
            }
        }
        return discoveredRedirects;
    }

    public static Map<String, String> transformRedirectsToOriginalNames(Map<String, String> redirects, ClassNode targetClass) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (MethodNode mth : targetClass.methods) {
            String val;
            if (!(mth instanceof MethodNodeEx) || (val = redirects.get(((MethodNodeEx)mth).getOriginalName())) == null) continue;
            ret.put(mth.name, val);
        }
        return ret;
    }

    public static void apply(ClassNode targetClass) {
        FabInjector.apply(targetClass, null);
    }

    public static void apply(ClassNode targetClass, List<ToInject> injectIn) {
        Map<Object, Object> existingRedirects = new HashMap();
        try {
            existingRedirects = FabInjector.transformRedirectsToOriginalNames(FabInjector.getMixinRedirects(targetClass.name), targetClass);
        }
        catch (Exception e) {
            FabLog.error("Failed to get mixin redirects please report this", e);
        }
        ArrayList<ToInject> injects = new ArrayList<ToInject>();
        ArrayList<EntryMixinMerged> redirects = new ArrayList<EntryMixinMerged>();
        for (MethodNode methodNode : targetClass.methods) {
            if (!(methodNode instanceof MethodNodeEx)) continue;
            AnnotationNode inject = null;
            String mixin = null;
            for (AnnotationNode annotationNode : methodNode.visibleAnnotations) {
                if (("Lcom/unascribed/fabrication/support/injection/ModifyReturn;".equals(annotationNode.desc) || "Lcom/unascribed/fabrication/support/injection/Hijack;".equals(annotationNode.desc) || "Lcom/unascribed/fabrication/support/injection/ModifyGetField;".equals(annotationNode.desc)) && dejavu.add(targetClass.name + methodNode.name + methodNode.desc)) {
                    inject = annotationNode;
                    continue;
                }
                if (!"Lorg/spongepowered/asm/mixin/transformer/meta/MixinMerged;".equals(annotationNode.desc)) continue;
                mixin = (String)annotationNode.values.get(annotationNode.values.indexOf("mixin") + 1);
                if (!existingRedirects.containsKey(methodNode.name)) continue;
                redirects.add(new EntryMixinMerged(methodNode.name, methodNode.desc, mixin, (String)existingRedirects.get(methodNode.name)));
            }
            if (inject == null || mixin == null || injectIn != null) continue;
            String mix = mixin;
            injects.add(new ToInject(((List)inject.values.get(inject.values.indexOf("method") + 1)).stream().map(s -> FabRefMap.relativeMap(mix, s)).collect(Collectors.toList()), ((List)inject.values.get(inject.values.indexOf("target") + 1)).stream().map(FabRefMap::absoluteMap).collect(Collectors.toList()), targetClass.name, methodNode.name, methodNode.desc, methodNode.access | targetClass.access & 0x200, inject.desc, mixin));
        }
        FabInjector.apply(targetClass, injectIn != null ? injectIn : injects, redirects);
    }

    public static void apply(ClassNode targetClass, List<ToInject> injects, List<EntryMixinMerged> redirects) {
        HashMap<CallSite, String> redirectMap = new HashMap<CallSite, String>();
        for (ToInject toInject : injects) {
            if (toInject.annotation.equals("Lcom/unascribed/fabrication/support/injection/ModifyGetField;")) continue;
            for (EntryMixinMerged redirect : redirects) {
                String mapped = FabRefMap.absoluteMap(redirect.target);
                if (!toInject.target.contains(mapped)) continue;
                String r = redirect.name + redirect.desc;
                toInject.potentiallyRedirected.add(r);
                redirectMap.put((CallSite)((Object)r), mapped);
                FabLog.info("FabInjector found a Redirect from " + redirect.mixin + ";" + redirect.name + "; which has been added to " + toInject.owner + ";" + toInject.name);
            }
        }
        for (MethodNode methodNode : targetClass.methods) {
            for (ToInject toInject : injects) {
                for (String m : toInject.method) {
                    if (!m.equals(methodNode.name + methodNode.desc)) continue;
                    for (AbstractInsnNode insnNode : methodNode.instructions) {
                        String insnOwner = null;
                        String insnName = null;
                        Object insnDesc = null;
                        if (insnNode instanceof MethodInsnNode) {
                            insn = (MethodInsnNode)insnNode;
                            insnOwner = insn.owner;
                            insnName = insn.name;
                            insnDesc = insn.desc;
                        } else if (insnNode instanceof FieldInsnNode) {
                            insn = (FieldInsnNode)insnNode;
                            insnOwner = insn.owner;
                            insnName = insn.name;
                            insnDesc = ":" + insn.desc;
                        }
                        if (insnOwner == null || insnName == null || insnDesc == null) continue;
                        Iterator<String> iterator = toInject.target.iterator();
                        while (iterator.hasNext()) {
                            char d;
                            String target;
                            String unchangedTarget = target = iterator.next();
                            if (target.charAt(0) == 'L') {
                                target = target.substring(1);
                            }
                            if (!target.startsWith(insnOwner) || (d = target.charAt(insnOwner.length())) != '.' && d != ';' || !target.substring(insnOwner.length() + 1).equals(insnName + (String)insnDesc) || !FabInjector.performInjection(methodNode, insnNode, toInject, target, false, targetClass)) continue;
                            toInject.done.put(m, unchangedTarget);
                            String type = toInject.annotation.substring(toInject.annotation.lastIndexOf(47), toInject.annotation.length() - 1);
                            FabLog.debug("Completed " + type + " Injection : " + toInject.owner + ";" + m + "\t" + unchangedTarget);
                        }
                        if (!toInject.owner.equals(insnOwner)) continue;
                        for (String target : toInject.potentiallyRedirected) {
                            if (!target.equals(insnName + (String)insnDesc) || !FabInjector.performInjection(methodNode, insnNode, toInject, target, true, targetClass)) continue;
                            toInject.redirect_fixed.put(m, (String)redirectMap.get(target));
                            String type = toInject.annotation.substring(toInject.annotation.lastIndexOf(47), toInject.annotation.length() - 1);
                            FabLog.debug("Completed " + type + " Injection over existing Redirect : " + toInject.owner + ";" + m + "\t" + target);
                        }
                    }
                }
            }
        }
        for (ToInject ti : injects) {
            for (String m : ti.method) {
                for (String t : ti.target) {
                    if (t.equals(ti.done.get(m))) continue;
                    if (t.equals(ti.redirect_fixed.get(m))) {
                        FabLog.warn("FabInjector failed to find injection point for " + ti.owner + ";" + m + "\t" + t + "\n may have been caused by another mods Redirect, assuming fixed");
                        continue;
                    }
                    FabLog.warn("FabInjector failed to find injection point for " + ti.owner + ";" + m + "\t" + t + "\n located in " + ti.mixin);
                    Set<String> keys = MixinConfigPlugin.getConfigKeysForDiscoveredClass(ti.mixin);
                    if (keys.isEmpty()) continue;
                    FabLog.warn("! Force-disabling " + Joiner.on((String)", ").join(keys));
                    for (String opt : keys) {
                        if (ti.potentiallyRedirected.isEmpty()) {
                            FabConf.addFailure(opt, "Injection Fail");
                            continue;
                        }
                        FabConf.addFailure(opt, "Injection Fail: Likely Mod Conflict");
                    }
                }
            }
        }
    }

    public static boolean performInjection(MethodNode methodNode, AbstractInsnNode insn, ToInject toInject, String target, boolean isRedirect, ClassNode classNode) {
        ArrayList<Runnable> undo = new ArrayList<Runnable>();
        boolean ret = FabInjector.performInjection(methodNode, insn, toInject, target, isRedirect, undo);
        Exception e = FabInjector.verifyMethodNode(classNode, methodNode);
        if (e == null) {
            return ret;
        }
        FabLog.error("Injection test failed, attempting recovery, this is likely a mod conflict, please report it\n" + e.getLocalizedMessage());
        for (Runnable u : undo) {
            if (u == null) continue;
            u.run();
        }
        return false;
    }

    public static Exception verifyMethodNode(ClassNode classNode, MethodNode method) {
        Type syperType = classNode.superName == null ? null : Type.getObjectType((String)classNode.superName);
        ArrayList<Type> interfaces = new ArrayList<Type>();
        for (String interfaceName : classNode.interfaces) {
            interfaces.add(Type.getObjectType((String)interfaceName));
        }
        MixinVerifier verifier = new MixinVerifier(589824, Type.getObjectType((String)classNode.name), syperType, interfaces, (classNode.access & 0x200) != 0);
        Analyzer analyzer = new Analyzer((Interpreter)verifier);
        try {
            analyzer.analyzeAndComputeMaxs(classNode.name, method);
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public static AbstractInsnNode addUndoInsn(AbstractInsnNode insnNode, InsnList list, List<Runnable> undo) {
        undo.add(() -> list.remove(insnNode));
        return insnNode;
    }

    public static boolean performInjection(MethodNode methodNode, AbstractInsnNode insn, ToInject toInject, String target, boolean isRedirect, List<Runnable> undo) {
        int max;
        int brac;
        boolean toInjectIsStatic = (toInject.access & 8) != 0;
        InsnList mod = new InsnList();
        ArrayList<Type> argTypes = new ArrayList<Type>();
        if (insn.getOpcode() != 184 && insn.getOpcode() != 180 && insn.getOpcode() != 178) {
            argTypes.add(Type.VOID_TYPE);
        }
        Type targetType = Type.getMethodType((String)target.substring((brac = target.indexOf(40)) == -1 ? target.lastIndexOf(58) + 1 : brac));
        if (brac != -1) {
            argTypes.addAll(Arrays.asList(targetType.getArgumentTypes()));
        }
        Type toInjectType = Type.getMethodType((String)toInject.desc);
        Type[] toInjectArgTypes = toInjectType.getArgumentTypes();
        int countDesc = toInjectArgTypes.length;
        int fmax = max = methodNode.maxLocals;
        undo.add(() -> {
            methodNode.maxLocals = fmax;
        });
        InsnList oldVars = new InsnList();
        InsnList newVars = new InsnList();
        InsnList instructions = methodNode.instructions;
        if ("Lcom/unascribed/fabrication/support/injection/ModifyGetField;".equals(toInject.annotation)) {
            int c;
            if (!toInjectIsStatic) {
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getStoreOpcode(targetType.getReturnType().getSort()), max), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(25, 0), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getLoadOpcode(targetType.getReturnType().getSort()), max++), instructions, undo));
            }
            if (--countDesc > 0) {
                String clazz = ((FieldInsnNode)insn).owner;
                int type = Type.getType((String)(clazz.startsWith("L") ? clazz : "L" + clazz)).getSort();
                instructions.insertBefore(insn, FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getStoreOpcode(type), max), instructions, undo));
                instructions.insertBefore(insn, FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getLoadOpcode(type), max), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getLoadOpcode(type), max++), instructions, undo));
                --countDesc;
            }
            methodNode.maxLocals = max;
            int n = c = toInjectIsStatic ? 0 : 1;
            while (c < countDesc) {
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getLoadOpcode(toInjectArgTypes[toInjectArgTypes.length - countDesc + c].getSort()), c), instructions, undo));
                ++c;
            }
            mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new MethodInsnNode(toInjectIsStatic ? 184 : 182, toInject.owner, toInject.name, toInject.desc, (toInject.access & 0x200) != 0), instructions, undo));
            instructions.insert(insn, mod);
            return true;
        }
        if ("Lcom/unascribed/fabrication/support/injection/ModifyReturn;".equals(toInject.annotation)) {
            if (--countDesc > 0) {
                int c;
                boolean isSeqVar;
                AbstractInsnNode varTrace = insn.getPrevious();
                boolean bl = isSeqVar = varTrace != null && FabInjector.isVariableLoader(varTrace.getOpcode());
                if (!isSeqVar) {
                    varTrace = null;
                }
                for (int c2 = 0; c2 < argTypes.size(); ++c2) {
                    if (isSeqVar) {
                        oldVars.insert(varTrace.clone(new HashMap()));
                        AbstractInsnNode tmp = varTrace.getPrevious();
                        if (tmp != null && FabInjector.isVariableLoader(tmp.getOpcode())) {
                            varTrace = tmp;
                            continue;
                        }
                        isSeqVar = false;
                        continue;
                    }
                    int sort = ((Type)argTypes.get(argTypes.size() - 1 - c2)).getSort();
                    newVars.insert(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getLoadOpcode(sort), max), instructions, undo));
                    instructions.insertBefore(varTrace == null ? insn : varTrace, FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getStoreOpcode(sort), max++), instructions, undo));
                }
                methodNode.maxLocals = max;
                if (!toInjectIsStatic) {
                    mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getStoreOpcode(targetType.getReturnType().getSort()), methodNode.maxLocals), instructions, undo));
                    mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(25, 0), instructions, undo));
                    mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getLoadOpcode(targetType.getReturnType().getSort()), methodNode.maxLocals), instructions, undo));
                    ++methodNode.maxLocals;
                }
                if (isRedirect && !argTypes.isEmpty() && argTypes.get(0) == Type.VOID_TYPE) {
                    if (newVars.size() > 0) {
                        newVars.remove(newVars.getFirst());
                    } else if (oldVars.size() > 0) {
                        oldVars.remove(oldVars.getFirst());
                    }
                }
                for (AbstractInsnNode a : newVars) {
                    if (countDesc-- <= 0) continue;
                    mod.add(FabInjector.addUndoInsn(a.clone(new HashMap()), instructions, undo));
                }
                for (AbstractInsnNode a : oldVars) {
                    if (countDesc-- <= 0) continue;
                    mod.add(FabInjector.addUndoInsn(a.clone(new HashMap()), instructions, undo));
                }
                instructions.insertBefore(varTrace == null ? insn : varTrace, newVars);
                int n = c = toInjectIsStatic ? 0 : 1;
                while (c < countDesc) {
                    mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getLoadOpcode(toInjectArgTypes[toInjectArgTypes.length - countDesc + c].getSort()), c), instructions, undo));
                    ++c;
                }
            } else if (!toInjectIsStatic) {
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getStoreOpcode(targetType.getReturnType().getSort()), methodNode.maxLocals), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(25, 0), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getLoadOpcode(targetType.getReturnType().getSort()), methodNode.maxLocals), instructions, undo));
                ++methodNode.maxLocals;
            }
            mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new MethodInsnNode(toInjectIsStatic ? 184 : 182, toInject.owner, toInject.name, toInject.desc, (toInject.access & 0x200) != 0), instructions, undo));
            instructions.insert(insn, mod);
            return true;
        }
        if ("Lcom/unascribed/fabrication/support/injection/Hijack;".equals(toInject.annotation)) {
            int c;
            for (int c3 = 0; c3 < argTypes.size(); ++c3) {
                instructions.insertBefore(insn, FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getStoreOpcode(((Type)argTypes.get(argTypes.size() - 1 - c3)).getSort()), max++), instructions, undo));
            }
            LabelNode label = new LabelNode(new Label());
            LabelNode label2 = new LabelNode(new Label());
            boolean optionalReturn = toInjectType.getReturnType().getSort() != 1;
            mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new MethodInsnNode(toInjectIsStatic ? 184 : 182, toInject.owner, toInject.name, toInject.desc, (toInject.access & 0x200) != 0), instructions, undo));
            if (optionalReturn) {
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(58, max), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(25, max), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new JumpInsnNode(198, label), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(25, max), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new FieldInsnNode(180, "com/unascribed/fabrication/support/injection/HijackReturn", "object", "Ljava/lang/Object;"), instructions, undo));
                FabInjector.castHijackReturnResult(targetType.getReturnType(), i -> mod.add(FabInjector.addUndoInsn(i, instructions, undo)));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new JumpInsnNode(167, label2), instructions, undo));
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)label, instructions, undo));
                methodNode.maxLocals = max + 1;
            } else {
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new JumpInsnNode(154, label), instructions, undo));
                methodNode.maxLocals = max;
            }
            if (!toInjectIsStatic) {
                methodNode.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            }
            for (int i2 = 0; i2 < argTypes.size(); ++i2) {
                Type argType = (Type)argTypes.get(i2);
                int opcode = FabInjector.getLoadOpcode(argType.getSort());
                mod.add(FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(opcode, --max), instructions, undo));
                if (i2 == 0 && argTypes.get(0) == Type.VOID_TYPE && isRedirect || countDesc-- <= 0) continue;
                instructions.insertBefore(insn, FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(opcode, max), instructions, undo));
            }
            int n = c = toInjectIsStatic ? 0 : 1;
            while (c < countDesc) {
                instructions.insertBefore(insn, FabInjector.addUndoInsn((AbstractInsnNode)new VarInsnNode(FabInjector.getLoadOpcode(toInjectArgTypes[toInjectArgTypes.length - countDesc + c].getSort()), c), instructions, undo));
                ++c;
            }
            instructions.insertBefore(insn, mod);
            instructions.insert(insn, FabInjector.addUndoInsn((AbstractInsnNode)(optionalReturn ? label2 : label), instructions, undo));
            return true;
        }
        return false;
    }

    public static void castHijackReturnResult(Type desc, Consumer<AbstractInsnNode> insnConsumer) {
        switch (desc.getSort()) {
            case 1: {
                insnConsumer.accept((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Boolean"));
                insnConsumer.accept((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
                break;
            }
            case 3: {
                insnConsumer.accept((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Byte"));
                insnConsumer.accept((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Byte", "byteValue", "()B", false));
                break;
            }
            case 2: {
                insnConsumer.accept((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Character"));
                insnConsumer.accept((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Character", "charValue", "()C", false));
                break;
            }
            case 4: {
                insnConsumer.accept((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Short"));
                insnConsumer.accept((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Short", "shortValue", "()S", false));
                break;
            }
            case 5: {
                insnConsumer.accept((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Integer"));
                insnConsumer.accept((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Integer", "intValue", "()I", false));
                break;
            }
            case 7: {
                insnConsumer.accept((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Long"));
                insnConsumer.accept((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Long", "longValue", "()J", false));
                break;
            }
            case 6: {
                insnConsumer.accept((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Float"));
                insnConsumer.accept((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Float", "floatValue", "()F", false));
                break;
            }
            case 8: {
                insnConsumer.accept((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Double"));
                insnConsumer.accept((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Double", "doubleValue", "()D", false));
                break;
            }
            default: {
                String descStr = desc.toString();
                insnConsumer.accept((AbstractInsnNode)new TypeInsnNode(192, descStr.substring(1, descStr.length() - 1)));
            }
        }
    }

    public static int getStoreOpcode(int type) {
        return FabInjector.getLoadOpcode(type) + 33;
    }

    public static int getLoadOpcode(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 21;
            }
            case 7: {
                return 22;
            }
            case 6: {
                return 23;
            }
            case 8: {
                return 24;
            }
        }
        return 25;
    }

    public static boolean isVariableLoader(int opcode) {
        switch (opcode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    static {
        try {
            Field f_mixins = ClassInfo.class.getDeclaredField("mixins");
            f_mixins.setAccessible(true);
            getMixinInfoFromClassInfo = info -> {
                try {
                    return (Set)f_mixins.get(info);
                }
                catch (Exception e) {
                    FabLog.error("FabInjector failed to reflect mixin: " + info.getClassName(), e);
                    return Collections.emptySet();
                }
            };
        }
        catch (Throwable e) {
            FabLog.error("FabInjector failed to reflect mixin fields, redirect fixer has been disabled", e);
        }
        getMixinReferenceMapper = i -> null;
        try {
            Class<?> classMixinConfig = Class.forName("org.spongepowered.asm.mixin.transformer.MixinConfig");
            Method getMapper = classMixinConfig.getMethod("getReferenceMapper", new Class[0]);
            getMapper.setAccessible(true);
            getMixinReferenceMapper = i -> {
                try {
                    IMixinConfig conf = i.getConfig();
                    if (classMixinConfig.isInstance(conf)) {
                        return (IReferenceMapper)getMapper.invoke((Object)conf, new Object[0]);
                    }
                }
                catch (Exception e) {
                    FabLog.error("FabInjector failed to reflect mixin: " + i.getClassName(), e);
                }
                return null;
            };
        }
        catch (Throwable e) {
            FabLog.error("FabInjector failed to reflect mixin remapper", e);
        }
        dejavu = new HashSet<String>();
    }

    public static class EntryMixinMerged {
        String name;
        String desc;
        String mixin;
        String target;

        EntryMixinMerged(String name, String desc, String mixin, String target) {
            this.name = name;
            this.desc = desc;
            this.mixin = mixin;
            this.target = target;
        }
    }

    public static class ToInject {
        public final List<String> potentiallyRedirected = new ArrayList<String>();
        public Map<String, String> done = new HashMap<String, String>();
        public Map<String, String> redirect_fixed = new HashMap<String, String>();
        public List<String> method;
        public List<String> target;
        public String owner;
        public String name;
        public String desc;
        public int access;
        public String annotation;
        public String mixin;

        public ToInject(List<String> method, List<String> target, String owner, String name, String desc, int opcode, String annotation, String mixin) {
            this.method = method;
            this.target = target;
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.access = opcode;
            this.annotation = annotation;
            this.mixin = mixin;
        }
    }
}

