/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support.injection;

import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.support.MixinErrorHandler;
import com.unascribed.fabrication.support.injection.FabRefMap;
import java.lang.reflect.Field;
import java.util.List;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.mixin.extensibility.IMixinErrorHandler;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.code.Injector;

public class FabMixinInjector {
    public static void remap(String mixinOrigin, AnnotationNode annotation) {
        Object val;
        int i;
        Object list;
        int ann_i = annotation.values.indexOf("method");
        if (ann_i != -1 && (list = annotation.values.get(ann_i + 1)) instanceof List) {
            ann_i = ((List)list).size();
            for (i = 0; i < ann_i; ++i) {
                val = ((List)list).get(i);
                if (!(val instanceof String)) continue;
                ((List)list).set(i, FabRefMap.relativeMap(mixinOrigin, (String)val));
            }
        }
        if ((ann_i = annotation.values.indexOf("at")) != -1) {
            Object maybeList = annotation.values.get(ann_i + 1);
            if (maybeList instanceof List) {
                ann_i = ((List)maybeList).size();
                for (i = 0; i < ann_i; ++i) {
                    val = ((List)maybeList).get(i);
                    if (!(val instanceof AnnotationNode)) continue;
                    FabMixinInjector.remapAt((AnnotationNode)val);
                }
            } else if (maybeList instanceof AnnotationNode) {
                FabMixinInjector.remapAt((AnnotationNode)maybeList);
            }
        }
    }

    private static void remapAt(AnnotationNode annotation) {
        Object val;
        int ann_i = annotation.values.indexOf("target");
        if (ann_i++ != -1 && (val = annotation.values.get(ann_i)) instanceof String) {
            annotation.values.set(ann_i, FabRefMap.absoluteMap((String)val));
        }
    }

    public static Injector doctorAnnotation(String annotationType, Injector injector) {
        try {
            Field at = Injector.class.getDeclaredField("annotationType");
            at.setAccessible(true);
            at.set(injector, annotationType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return injector;
    }

    public static void handleErrorProactively(String targetClassName, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        if ((action = MixinErrorHandler.onError(th, mixin, action, "postApply")) == IMixinErrorHandler.ErrorAction.ERROR) {
            throw new RuntimeException(th);
        }
        if (action == IMixinErrorHandler.ErrorAction.WARN) {
            FabLog.warn("Mixin application failed", th);
        }
    }
}

