/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.unascribed.fabrication.loaders.LoaderBlockLogo;
import com.unascribed.fabrication.logic.LogoBlock;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class BlockLogoRenderer {
    private LogoBlock[][] blocks = null;

    public void tick() {
        if (this.blocks != null) {
            LogoBlock[][] logoBlockArray = this.blocks;
            int n = logoBlockArray.length;
            for (int i = 0; i < n; ++i) {
                LogoBlock[] fabrication$block;
                for (LogoBlock blk : fabrication$block = logoBlockArray[i]) {
                    if (blk == null) continue;
                    blk.tick();
                }
            }
        }
    }

    public void drawLogo(boolean doBackgroundFade, long backgroundFadeStart, float partialTicks) {
        int logoDataHeight;
        Minecraft mc = Minecraft.m_91087_();
        float fade = doBackgroundFade ? Mth.m_14036_((float)((float)(Util.m_137550_() - backgroundFadeStart) / 1000.0f - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        int logoDataWidth = LoaderBlockLogo.unrecoverableLoadError ? 48 : LoaderBlockLogo.image.m_84982_();
        int n = logoDataHeight = LoaderBlockLogo.unrecoverableLoadError ? 5 : LoaderBlockLogo.image.m_85084_();
        if (this.blocks == null || LoaderBlockLogo.invalidated) {
            LoaderBlockLogo.invalidated = false;
            boolean reverse = LoaderBlockLogo.getReverse.getAsBoolean();
            this.blocks = new LogoBlock[logoDataWidth][logoDataHeight];
            if (LoaderBlockLogo.unrecoverableLoadError) {
                String[] error = new String[]{"### ### ### ### ###    ### ### ###   #   ### ###", "#   # # # # # # # #    #   #   #     #   # # #  ", "##  ##  ##  # # ##     ### ##  ##    #   # # # #", "#   # # # # # # # #      # #   #     #   # # # #", "### # # # # ### # # #  ### ### ###   ### ### ###"};
                for (x = 0; x < error[0].length(); ++x) {
                    for (y = 0; y < error.length; ++y) {
                        char c = error[y].charAt(x);
                        if (c == ' ') continue;
                        state = null;
                        this.blocks[x][y] = new LogoBlock(reverse ? logoDataWidth - x : x, y, state);
                    }
                }
            } else {
                NativeImage img = LoaderBlockLogo.image;
                for (x = 0; x < logoDataWidth; ++x) {
                    for (y = 0; y < logoDataHeight; ++y) {
                        int color = img.m_84985_(x, y);
                        if ((color & 0xFF000000) == 0 || (state = LoaderBlockLogo.colorToState.getOrDefault(color & 0xFFFFFF, () -> ((Block)Blocks.f_50016_).m_49966_()).get()).m_60795_() || state.m_60799_() == RenderShape.INVISIBLE) continue;
                        this.blocks[x][y] = new LogoBlock(reverse ? logoDataWidth - x : x, y, state);
                    }
                }
            }
        }
        PoseStack matrices = new PoseStack();
        RenderSystem.m_157183_();
        int logoHeight = (int)(120.0 * mc.m_91268_().m_85449_());
        Matrix4f pmat = Matrix4f.m_27625_((double)70.0, (float)((float)mc.m_91268_().m_85441_() / (float)logoHeight), (float)0.05f, (float)100.0f);
        RenderSystem.m_157425_((Matrix4f)pmat);
        RenderSystem.m_69949_((int)0, (int)(mc.m_91268_().m_85442_() - logoHeight), (int)mc.m_91268_().m_85441_(), (int)logoHeight);
        matrices.m_85836_();
        matrices.m_166856_();
        matrices.m_85837_((double)0.4f, (double)0.6f, 1987.0);
        RenderSystem.m_69464_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69914_((Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(0.0f, -1.0f, -0.7f), Vector3f::m_122278_)), (Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(0.0f, -1.0f, -0.7f), Vector3f::m_122278_)), (Matrix4f)matrices.m_85850_().m_85861_());
        BlockRenderDispatcher brm = mc.m_91289_();
        BufferBuilder bb = Tesselator.m_85913_().m_85915_();
        for (int pass = 0; pass < 2; ++pass) {
            matrices.m_85836_();
            if (pass == 0) {
                RenderSystem.m_69421_((int)256, (boolean)false);
                matrices.m_85837_(0.0, (double)-0.4f, 0.0);
                matrices.m_85841_(0.98f, 1.0f, 1.0f);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
            }
            if (pass == 1) {
                RenderSystem.m_69461_();
                RenderSystem.m_69421_((int)256, (boolean)false);
            }
            if (pass == 2) {
                RenderSystem.m_69478_();
                RenderSystem.m_69405_((int)768, (int)1);
            }
            matrices.m_85841_(1.0f, -1.0f, 1.0f);
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(15.0f));
            matrices.m_85841_(0.89f, 1.0f, 0.4f);
            matrices.m_85837_((double)((float)(-logoDataWidth) * 0.5f), (double)((float)(-logoDataHeight) * 0.5f), 0.0);
            if (pass == 0) {
                RenderSystem.m_69472_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.m_69493_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            for (int y = 0; y < logoDataHeight; ++y) {
                for (int x = 0; x < logoDataWidth; ++x) {
                    LogoBlock blk = this.blocks[x][y];
                    if (blk == null) continue;
                    BlockState state = blk.state;
                    matrices.m_85836_();
                    float position = blk.lastPosition + (blk.position - blk.lastPosition) * partialTicks;
                    float scale = 1.0f;
                    float alpha = 1.0f;
                    float rot = 0.0f;
                    if (pass == 0) {
                        scale = position * 0.04f + 1.0f;
                        alpha = 1.0f / scale;
                        position = 0.0f;
                    }
                    matrices.m_85837_((double)x, (double)y, (double)position);
                    matrices.m_85841_(scale, scale, scale);
                    matrices.m_85845_(Vector3f.f_122225_.m_122240_(rot));
                    if (pass != 0) {
                        mc.m_91097_().m_174784_(InventoryMenu.f_39692_);
                        RenderSystem.m_157427_(GameRenderer::m_172838_);
                        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (state == null) {
                            bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
                            TextureAtlasSprite missing = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("missingno", "missingno"));
                            float minU = missing.m_118409_();
                            float minV = missing.m_118411_();
                            float maxU = missing.m_118410_();
                            float maxV = missing.m_118412_();
                            Matrix4f mat = matrices.m_85850_().m_85861_();
                            bb.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_7421_(minU, minV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_7421_(maxU, minV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_7421_(maxU, maxV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 0.0f, 1.0f).m_7421_(minU, maxV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_7421_(minU, minV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_7421_(maxU, minV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_7421_(minU, minV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_7421_(maxU, minV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_7421_(maxU, maxV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_7421_(minU, maxV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 0.0f, 1.0f).m_7421_(minU, minV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_7421_(maxU, minV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_7421_(minU, minV).m_6122_(255, 255, 255, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_7421_(maxU, minV).m_6122_(255, 255, 255, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_6122_(255, 255, 255, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 0.0f, 0.0f, 1.0f).m_7421_(minU, maxV).m_6122_(255, 255, 255, 255).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_7421_(minU, minV).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_7421_(maxU, minV).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bb.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_7421_(minU, maxV).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            Tesselator.m_85913_().m_85914_();
                        } else {
                            MultiBufferSource.BufferSource vertexConsumer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                            matrices.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                            matrices.m_85837_(0.0, 0.0, -1.0);
                            brm.m_110912_(state, matrices, (MultiBufferSource)vertexConsumer, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
                            vertexConsumer.m_109911_();
                        }
                    } else {
                        RenderSystem.m_157427_(GameRenderer::m_172808_);
                        RenderSystem.m_157429_((float)LoaderBlockLogo.shadowRed, (float)LoaderBlockLogo.shadowGreen, (float)LoaderBlockLogo.shadowBlue, (float)(LoaderBlockLogo.shadowAlpha * alpha * fade));
                        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                        Matrix4f mat = matrices.m_85850_().m_85861_();
                        bb.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 0.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 1.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 1.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 0.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 1.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 1.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 1.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 0.0f, 0.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 0.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 1.0f, 1.0f).m_5752_();
                        bb.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_5752_();
                        Tesselator.m_85913_().m_85914_();
                    }
                    matrices.m_85849_();
                }
            }
            matrices.m_85849_();
        }
        Lighting.m_84930_();
        RenderSystem.m_69832_((float)1.0f);
        RenderSystem.m_69461_();
        RenderSystem.m_157424_();
        RenderSystem.m_69949_((int)0, (int)0, (int)mc.m_91268_().m_85441_(), (int)mc.m_91268_().m_85442_());
        matrices.m_85849_();
        RenderSystem.m_69481_();
    }
}

