/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.client.living.model.EntityModelJS;
import net.liopyu.entityjs.client.living.model.GeoLayerJS;
import net.liopyu.entityjs.client.living.model.GeoLayerJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.liolib.cache.object.BakedGeoModel;
import net.liopyu.liolib.renderer.GeoEntityRenderer;
import net.liopyu.liolib.util.RenderUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;

public class KubeJSEntityRenderer<T extends LivingEntity>
extends GeoEntityRenderer<T> {
    private final BaseLivingEntityBuilder<T> builder;

    public KubeJSEntityRenderer(EntityRendererProvider.Context renderManager, BaseLivingEntityBuilder<T> builder) {
        super(renderManager, new EntityModelJS<T>(builder));
        this.builder = builder;
        this.scaleHeight = this.getScaleHeight();
        this.scaleWidth = this.getScaleWidth();
        for (GeoLayerJSBuilder<T> geoBuilder : builder.layerList) {
            GeoLayerJS layerPart = geoBuilder.build(this, builder);
            this.addRenderLayer(layerPart);
        }
    }

    public String entityName() {
        return ((LivingEntity)this.animatable).m_6095_().toString();
    }

    public float getScaleHeight() {
        return this.builder.scaleHeight;
    }

    public float getScaleWidth() {
        return this.builder.scaleWidth;
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (this.builder.scaleModelForRender != null && this.animatable != null) {
            ContextUtils.ScaleModelRenderContext<T> context = new ContextUtils.ScaleModelRenderContext<T>(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.builder.scaleModelForRender, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: scaleModelForRender.");
            super.scaleModelForRender(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        } else {
            super.scaleModelForRender(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return (ResourceLocation)this.builder.textureResource.apply(entity);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return switch (((IAnimatableJS)animatable).getBuilder().renderType) {
            default -> throw new IncompatibleClassChangeError();
            case BaseLivingEntityBuilder.RenderType.SOLID -> RenderType.m_110446_((ResourceLocation)texture);
            case BaseLivingEntityBuilder.RenderType.CUTOUT -> RenderType.m_110452_((ResourceLocation)texture);
            case BaseLivingEntityBuilder.RenderType.TRANSLUCENT -> RenderType.m_110473_((ResourceLocation)texture);
        };
    }

    public void render(T animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (this.builder.render != null && this.animatable != null) {
            ContextUtils.RenderContext<T> context = new ContextUtils.RenderContext<T>(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
            EntityJSHelperClass.consumerCallback(this.builder.render, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: render.");
            super.m_7392_(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        } else {
            super.m_7392_(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        Pose pose = animatable.m_20089_();
        if (pose != Pose.SLEEPING) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        }
        if (((LivingEntity)animatable).f_20919_ > 0 && this.builder.defaultDeathPose.booleanValue()) {
            float deathRotation = ((float)((LivingEntity)animatable).f_20919_ + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(Math.min(Mth.m_14116_((float)deathRotation), 1.0f) * this.getDeathMaxRotation((Entity)animatable)));
        } else if (animatable.m_21209_()) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f - animatable.m_146909_()));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(((float)((LivingEntity)animatable).f_19797_ + partialTick) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction bedOrientation = animatable.m_21259_();
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(bedOrientation != null ? RenderUtils.getDirectionAngle((Direction)bedOrientation) : rotationYaw));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(this.getDeathMaxRotation((Entity)animatable)));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
        } else if (animatable.m_8077_() || animatable instanceof Player) {
            String name = animatable.m_7755_().getString();
            if (animatable instanceof Player) {
                Player player = (Player)animatable;
                if (!player.m_36170_(PlayerModelPart.CAPE)) {
                    return;
                }
            } else {
                name = ChatFormatting.m_126649_((String)name);
            }
            if (name != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
                poseStack.m_85837_(0.0, (double)(animatable.m_20206_() + 0.1f), 0.0);
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            }
            if (name != null && (name.equalsIgnoreCase("liopyu") || name.equalsIgnoreCase("toomuchmail"))) {
                poseStack.m_85837_(0.0, (double)(animatable.m_20206_() + 0.1f), 0.0);
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            }
        }
    }
}

