/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.item;

import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.BaseNonAnimatableEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileAnimatableJSBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileEntityJSBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.ProjectileAnimatableJS;
import net.liopyu.entityjs.entities.nonliving.entityjs.ProjectileEntityJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ProjectileItemBuilder
extends ItemBuilder {
    public final transient BuilderBase<?> parent;
    public transient boolean canThrow;
    public transient float projectileZ;
    public transient float projectileVelocity;
    public transient float projectileInaccuracy;

    public ProjectileItemBuilder(ResourceLocation i, BuilderBase<?> parent) {
        super(i);
        this.parent = parent;
        this.canThrow = false;
        this.projectileZ = 0.0f;
        this.projectileVelocity = 1.5f;
        this.projectileInaccuracy = 1.0f;
        this.texture = i.m_135827_() + ":item/" + i.m_135815_();
    }

    public Item createObject() {
        return new Item(this.createItemProperties()){

            public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
                if (ProjectileItemBuilder.this.canThrow) {
                    ItemStack $$3 = pPlayer.m_21120_(pUsedHand);
                    if (!pLevel.f_46443_) {
                        float pZ = ProjectileItemBuilder.this.projectileZ;
                        float pVelocity = ProjectileItemBuilder.this.projectileVelocity;
                        float pInaccuracy = ProjectileItemBuilder.this.projectileInaccuracy;
                        BuilderBase<?> builderBase = ProjectileItemBuilder.this.parent;
                        if (builderBase instanceof BaseNonAnimatableEntityBuilder) {
                            BaseNonAnimatableEntityBuilder builder = (BaseNonAnimatableEntityBuilder)builderBase;
                            newBuilder = (ProjectileEntityJSBuilder)builder;
                            ProjectileEntityJS $$4 = new ProjectileEntityJS((ProjectileEntityJSBuilder)newBuilder, (EntityType<? extends ThrowableItemProjectile>)((EntityType)newBuilder.get()), (LivingEntity)pPlayer, pLevel);
                            $$4.m_37446_($$3);
                            $$4.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), pZ, pVelocity, pInaccuracy);
                            pLevel.m_7967_((Entity)$$4);
                        } else {
                            newBuilder = ProjectileItemBuilder.this.parent;
                            if (newBuilder instanceof BaseEntityBuilder) {
                                BaseEntityBuilder builder = (BaseEntityBuilder)newBuilder;
                                newBuilder = (ProjectileAnimatableJSBuilder)builder;
                                ProjectileAnimatableJS $$4 = new ProjectileAnimatableJS((ProjectileAnimatableJSBuilder)newBuilder, (EntityType<? extends ThrowableItemProjectile>)((EntityType)newBuilder.get()), (LivingEntity)pPlayer, pLevel);
                                $$4.m_37446_($$3);
                                $$4.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), pZ, pVelocity, pInaccuracy);
                                pLevel.m_7967_((Entity)$$4);
                            }
                        }
                    }
                    pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    if (!pPlayer.m_150110_().f_35937_) {
                        $$3.m_41774_(1);
                    }
                    return InteractionResultHolder.m_19092_((Object)$$3, (boolean)pLevel.m_5776_());
                }
                return super.m_7203_(pLevel, pPlayer, pUsedHand);
            }
        };
    }

    @Info(value="Sets whether the item can be thrown.\n\n@param canThrow True if the item can be thrown, false otherwise.\n\nExample usage:\n```javascript\nitemBuilder.canThrow(true);\n```\n")
    public ItemBuilder canThrow(boolean canThrow) {
        this.canThrow = canThrow;
        return this;
    }

    @Info(value="Sets the Z offset for the projectile.\n\n@param projectileZ The Z offset for the projectile.\n\nExample usage:\n```javascript\nitemBuilder.projectileZ(0.5f);\n```\n")
    public ItemBuilder projectileZ(float projectileZ) {
        this.projectileZ = projectileZ;
        return this;
    }

    @Info(value="Sets the velocity of the projectile.\n\n@param projectileVelocity The velocity of the projectile.\n\nExample usage:\n```javascript\nitemBuilder.projectileVelocity(1.5f);\n```\n")
    public ItemBuilder projectileVelocity(float projectileVelocity) {
        this.projectileVelocity = projectileVelocity;
        return this;
    }

    @Info(value="Sets the inaccuracy of the projectile.\n\n@param projectileInaccuracy The inaccuracy of the projectile.\n\nExample usage:\n```javascript\nitemBuilder.projectileInaccuracy(0.1f);\n```\n")
    public ItemBuilder projectileInaccuracy(float projectileInaccuracy) {
        this.projectileInaccuracy = projectileInaccuracy;
        return this;
    }
}

