/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import dev.latvian.mods.kubejs.event.EventJS;
import java.util.Objects;
import net.liopyu.entityjs.builders.modification.ModifyEntityBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.events.AddGoalSelectorsEventJS;
import net.liopyu.entityjs.events.AddGoalTargetsEventJS;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, remap=true)
public class EntityMixin {
    @Unique
    private Object entityJs$builder;
    @Unique
    private Object entityJs$entityObject = this;

    @Unique
    private Entity entityJs$getLivingEntity() {
        return (Entity)this.entityJs$entityObject;
    }

    @Unique
    private String entityJs$entityName() {
        return this.entityJs$getLivingEntity().m_6095_().toString();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=true)
    private void entityjs$onEntityInit(EntityType<?> pEntityType, Level pLevel, CallbackInfo ci) {
        EntityType entityType = this.entityJs$getLivingEntity().m_6095_();
        if (EventHandlers.modifyEntity.hasListeners()) {
            EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, this.entityJs$getLivingEntity());
            EventHandlers.modifyEntity.post((EventJS)eventJS);
            this.entityJs$builder = eventJS.getBuilder();
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void onInteract(Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.onInteract != null) {
                ContextUtils.EntityInteractContext context = new ContextUtils.EntityInteractContext(this.entityJs$getLivingEntity(), pPlayer, pHand);
                EntityJSHelperClass.consumerCallback(builder.onInteract, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onInteract.");
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void tick(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.tick != null) {
                EntityJSHelperClass.consumerCallback(builder.tick, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: tick.");
            }
        }
    }

    @Inject(method={"getMyRidingOffset"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getMyRidingOffset(CallbackInfoReturnable<Double> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.myRidingOffset == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.myRidingOffset.apply(this.entityJs$getLivingEntity()), "double");
            if (obj != null) {
                cir.setReturnValue((Object)((Double)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for myRidingOffset from entity: " + this.entityJs$entityName() + ". Value: " + builder.myRidingOffset.apply(this.entityJs$getLivingEntity()) + ". Must be a double. Defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"lerpTo"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.lerpTo != null) {
                ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, teleport, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.lerpTo, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: lerpTo.");
            }
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void move(MoverType pType, Vec3 pPos, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.move != null) {
                ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.move, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: move.");
            }
        }
    }

    @Inject(method={"playerTouch"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void playerTouch(Player pPlayer, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (this.entityJs$builder != null && builder.playerTouch != null) {
                ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(pPlayer, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.playerTouch, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: playerTouch.");
            }
        }
    }

    @Inject(method={"onRemovedFromWorld"}, at={@At(value="HEAD", ordinal=0)}, remap=false, cancellable=true)
    public void onRemovedFromWorld(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.onRemovedFromWorld != null) {
                EntityJSHelperClass.consumerCallback(builder.onRemovedFromWorld, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onRemovedFromWorld.");
            }
        }
    }

    @Inject(method={"thunderHit"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.thunderHit != null) {
                ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(pLevel, pLightning, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.thunderHit, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: thunderHit.");
            }
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.onFall != null) {
                ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext(this.entityJs$getLivingEntity(), pMultiplier, pFallDistance, pSource);
                EntityJSHelperClass.consumerCallback(builder.onFall, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onLivingFall.");
            }
        }
    }

    @Inject(method={"onAddedToWorld"}, at={@At(value="HEAD", ordinal=0)}, remap=false, cancellable=true)
    public void onAddedToWorld(CallbackInfo ci) {
        Object object;
        if (!(this.entityJs$getLivingEntity() instanceof IAnimatableJS) && (object = this.entityJs$getLivingEntity()) instanceof Mob) {
            Mob m = (Mob)object;
            if (EventHandlers.addGoalTargets.hasListeners()) {
                EventHandlers.addGoalTargets.post(new AddGoalTargetsEventJS<Mob>(m, m.f_21346_), (Object)this.entityJs$getTypeId());
            }
            if (EventHandlers.addGoalSelectors.hasListeners()) {
                EventHandlers.addGoalSelectors.post(new AddGoalSelectorsEventJS<Mob>(m, m.f_21345_), (Object)this.entityJs$getTypeId());
            }
        }
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.onAddedToWorld != null && !this.entityJs$getLivingEntity().f_19853_.m_5776_()) {
                EntityJSHelperClass.consumerCallback(builder.onAddedToWorld, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onAddedToWorld.");
            }
        }
    }

    public String entityJs$getTypeId() {
        return Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)this.entityJs$getLivingEntity().m_6095_())).toString();
    }

    @Inject(method={"setSprinting"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void setSprinting(boolean pSprinting, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.onSprint != null) {
                EntityJSHelperClass.consumerCallback(builder.onSprint, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onSprint.");
            }
        }
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void stopRiding(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.onStopRiding != null) {
                EntityJSHelperClass.consumerCallback(builder.onStopRiding, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onStopRiding.");
            }
        }
    }

    @Inject(method={"rideTick"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void rideTick(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.rideTick != null) {
                EntityJSHelperClass.consumerCallback(builder.rideTick, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: rideTick.");
            }
        }
    }

    @Inject(method={"onClientRemoval"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void onClientRemoval(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.onClientRemoval != null) {
                EntityJSHelperClass.consumerCallback(builder.onClientRemoval, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onClientRemoval.");
            }
        }
    }

    @Inject(method={"lavaHurt"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void lavaHurt(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.lavaHurt != null) {
                EntityJSHelperClass.consumerCallback(builder.lavaHurt, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: lavaHurt.");
            }
        }
    }

    @Inject(method={"onFlap"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void onFlap(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.onFlap != null) {
                EntityJSHelperClass.consumerCallback(builder.onFlap, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onFlap.");
            }
        }
    }

    @Inject(method={"shouldRenderAtSqrDistance"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void shouldRenderAtSqrDistance(double pDistance, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.shouldRenderAtSqrDistance != null) {
                ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(pDistance, this.entityJs$getLivingEntity());
                Object obj = builder.shouldRenderAtSqrDistance.apply(context);
                if (obj instanceof Boolean) {
                    Boolean b = (Boolean)obj;
                    cir.setReturnValue((Object)b);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for arrow builder: " + obj + ". Must be a boolean. Defaulting to super method: " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"isAttackable"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isAttackable(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.isAttackable == null) {
                return;
            }
            cir.setReturnValue((Object)builder.isAttackable);
        }
    }

    @Inject(method={"getControllingPassenger"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getControllingPassenger(CallbackInfoReturnable<LivingEntity> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.controlledByFirstPassenger != null) {
                LivingEntity entity;
                if (!builder.controlledByFirstPassenger.booleanValue()) {
                    return;
                }
                Entity var2 = this.entityJs$getLivingEntity().m_146895_();
                LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
                cir.setReturnValue((Object)var10000);
            }
        }
    }

    @Inject(method={"canCollideWith"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canCollideWith(Entity pEntity, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.canCollideWith != null) {
                ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext(this.entityJs$getLivingEntity(), pEntity);
                Object obj = builder.canCollideWith.apply(context);
                if (obj instanceof Boolean) {
                    Boolean b = (Boolean)obj;
                    cir.setReturnValue((Object)b);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"getBlockJumpFactor"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void getBlockJumpFactor(CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.setBlockJumpFactor == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.setBlockJumpFactor.apply(this.entityJs$getLivingEntity()), "float");
            if (obj != null) {
                cir.setReturnValue((Object)Float.valueOf(((Float)obj).floatValue()));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityJs$entityName() + ". Value: " + builder.setBlockJumpFactor.apply(this.entityJs$getLivingEntity()) + ". Must be a float. Defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"isPushable"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isPushable(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.isPushable == null) {
                return;
            }
            cir.setReturnValue((Object)builder.isPushable);
        }
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void getBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.blockSpeedFactor == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.blockSpeedFactor.apply(this.entityJs$getLivingEntity()), "float");
            if (obj != null) {
                cir.setReturnValue((Object)Float.valueOf(((Float)obj).floatValue()));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityJs$entityName() + ". Value: " + builder.blockSpeedFactor.apply(this.entityJs$getLivingEntity()) + ". Must be a float, defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.positionRider != null) {
                ContextUtils.PositionRiderContextMove context = new ContextUtils.PositionRiderContextMove(this.entityJs$getLivingEntity(), pPassenger, pCallback);
                EntityJSHelperClass.consumerCallback(builder.positionRider, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: positionRider.");
                ci.cancel();
            }
        }
    }

    @Inject(method={"canAddPassenger"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void canAddPassenger(Entity pPassenger, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.canAddPassenger == null) {
                return;
            }
            ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(pPassenger, this.entityJs$getLivingEntity());
            Object obj = builder.canAddPassenger.apply(context);
            if (obj instanceof Boolean) {
                cir.setReturnValue((Object)((Boolean)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"isFlapping"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void isFlapping(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.isFlapping != null) {
                Object obj = builder.isFlapping.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"isPickable"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isPickable(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.isPickable == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.isPickable.apply(this.entityJs$getLivingEntity()), "boolean");
            if (obj != null) {
                cir.setReturnValue((Object)((Boolean)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isPickable from entity: " + this.entityJs$entityName() + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
            }
        }
    }

    @Inject(method={"repositionEntityAfterLoad"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void repositionEntityAfterLoad(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.repositionEntityAfterLoad == null) {
                return;
            }
            cir.setReturnValue((Object)builder.repositionEntityAfterLoad);
        }
    }

    @Inject(method={"getSwimSplashSound"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void getSwimSplashSound(CallbackInfoReturnable<SoundEvent> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.setSwimSplashSound == null) {
                return;
            }
            cir.setReturnValue((Object)Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)builder.setSwimSplashSound)));
        }
    }

    @Inject(method={"getSwimSound"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void getSwimSound(CallbackInfoReturnable<SoundEvent> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.setSwimSound == null) {
                return;
            }
            cir.setReturnValue((Object)Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)builder.setSwimSound)));
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.canFreeze != null) {
                Object obj = builder.canFreeze.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"isFreezing"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isFreezing(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.isFreezing != null) {
                Object obj = builder.isFreezing.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"isCurrentlyGlowing"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isCurrentlyGlowing(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (this.entityJs$builder != null && builder.isCurrentlyGlowing != null && !this.entityJs$getLivingEntity().f_19853_.m_5776_()) {
                Object obj = builder.isCurrentlyGlowing.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"dampensVibrations"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void dampensVibrations(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.dampensVibrations != null) {
                Object obj = builder.dampensVibrations.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"showVehicleHealth"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void showVehicleHealth(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.showVehicleHealth != null) {
                Object obj = builder.showVehicleHealth.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isInvulnerableTo(DamageSource pSource, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.isInvulnerableTo != null) {
                ContextUtils.EDamageContext context = new ContextUtils.EDamageContext(this.entityJs$getLivingEntity(), pSource);
                Object obj = builder.isInvulnerableTo.apply(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"canChangeDimensions"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canChangeDimensions(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.canChangeDimensions != null) {
                Object obj = builder.canChangeDimensions.apply(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"mayInteract"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void mayInteract(Level pLevel, BlockPos pPos, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.mayInteract != null) {
                ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(pLevel, pPos, this.entityJs$getLivingEntity());
                Object obj = builder.mayInteract.apply(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"canTrample"}, at={@At(value="HEAD", ordinal=0)}, remap=false, cancellable=true)
    public void canTrample(BlockState state, BlockPos pos, float fallDistance, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.canTrample != null) {
                ContextUtils.ECanTrampleContext context = new ContextUtils.ECanTrampleContext(state, pos, fallDistance, this.entityJs$getLivingEntity());
                Object obj = builder.canTrample.apply(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)((Boolean)obj));
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityJs$entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + cir.getReturnValue());
                }
            }
        }
    }

    @Inject(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    public void push(Entity pEntity, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.onEntityCollision != null) {
                ContextUtils.CollidingProjectileEntityContext context = new ContextUtils.CollidingProjectileEntityContext(this.entityJs$getLivingEntity(), pEntity);
                EntityJSHelperClass.consumerCallback(builder.onEntityCollision, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onEntityCollision.");
            }
        }
    }

    @Inject(method={"getMaxFallDistance"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getMaxFallDistance(CallbackInfoReturnable<Integer> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)((Object)object);
            if (builder.setMaxFallDistance == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.setMaxFallDistance.apply(this.entityJs$getLivingEntity()), "integer");
            if (obj != null) {
                cir.setReturnValue((Object)((Integer)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityJs$entityName() + ". Value: " + builder.setMaxFallDistance.apply(this.entityJs$getLivingEntity()) + ". Must be an integer. Defaulting to " + cir.getReturnValue());
            }
        }
    }
}

