/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util;

import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.liopyu.liolib.core.animation.Animation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;

public class EntityJSHelperClass {
    public static final Set<String> errorMessagesLogged = new HashSet<String>();
    public static final Set<String> warningMessagesLogged = new HashSet<String>();

    public static void logErrorMessageOnce(String errorMessage) {
        if (!errorMessagesLogged.contains(errorMessage)) {
            ConsoleJS.STARTUP.warn((Object)errorMessage);
            errorMessagesLogged.add(errorMessage);
        }
    }

    public static void logErrorMessageOnceCatchable(String errorMessage, Throwable e) {
        if (!errorMessagesLogged.contains(errorMessage)) {
            ConsoleJS.STARTUP.warn(errorMessage, e);
            errorMessagesLogged.add(errorMessage);
        }
    }

    public static void logWarningMessageOnce(String errorMessage) {
        if (!warningMessagesLogged.contains(errorMessage)) {
            ConsoleJS.STARTUP.warn((Object)errorMessage);
            warningMessagesLogged.add(errorMessage);
        }
    }

    public static <T> boolean consumerCallback(Consumer<T> consumer, T value, String errorMessage) {
        try {
            consumer.accept(value);
        }
        catch (Throwable e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable(errorMessage, e);
            return false;
        }
        return true;
    }

    public static Object convertObjectToDesired(Object input, String outputType) {
        return switch (outputType.toLowerCase()) {
            case "integer" -> EntityJSHelperClass.convertToInteger(input);
            case "double" -> EntityJSHelperClass.convertToDouble(input);
            case "float" -> EntityJSHelperClass.convertToFloat(input);
            case "boolean" -> EntityJSHelperClass.convertToBoolean(input);
            case "interactionresult" -> EntityJSHelperClass.convertToInteractionResult(input);
            case "resourcelocation" -> EntityJSHelperClass.convertToResourceLocation(input);
            case "looptype" -> EntityJSHelperClass.convertToLoopType(input);
            default -> input;
        };
    }

    public static RenderType convertToRenderType(Object input, Object defaultValue) {
        if (input == null) {
            return (RenderType)defaultValue;
        }
        if (input instanceof RenderType) {
            return (RenderType)input;
        }
        if (input instanceof String) {
            String string = (String)input;
            return RenderType.m_110452_((ResourceLocation)new ResourceLocation(string));
        }
        return null;
    }

    private static Animation.LoopType convertToLoopType(Object input) {
        if (input instanceof Animation.LoopType) {
            return (Animation.LoopType)input;
        }
        if (input instanceof String) {
            String stringValue;
            return switch (stringValue = ((String)input).toUpperCase()) {
                case "LOOP" -> Animation.LoopType.LOOP;
                case "PLAY_ONCE" -> Animation.LoopType.PLAY_ONCE;
                case "HOLD_ON_LAST_FRAME" -> Animation.LoopType.HOLD_ON_LAST_FRAME;
                default -> Animation.LoopType.DEFAULT;
            };
        }
        return Animation.LoopType.DEFAULT;
    }

    private static ResourceLocation convertToResourceLocation(Object input) {
        if (input instanceof ResourceLocation) {
            return (ResourceLocation)input;
        }
        if (input instanceof String) {
            return new ResourceLocation((String)input);
        }
        return null;
    }

    private static InteractionResult convertToInteractionResult(Object input) {
        if (input instanceof InteractionResult) {
            return (InteractionResult)input;
        }
        if (input instanceof String) {
            String stringValue;
            switch (stringValue = ((String)input).toLowerCase()) {
                case "success": {
                    return InteractionResult.SUCCESS;
                }
                case "consume": {
                    return InteractionResult.CONSUME;
                }
                case "pass": {
                    return InteractionResult.PASS;
                }
                case "fail": {
                    return InteractionResult.FAIL;
                }
                case "consume_partial": {
                    return InteractionResult.CONSUME_PARTIAL;
                }
            }
        }
        return null;
    }

    private static Boolean convertToBoolean(Object input) {
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        if (input instanceof String) {
            String stringValue = ((String)input).toLowerCase();
            if ("true".equals(stringValue)) {
                return true;
            }
            if ("false".equals(stringValue)) {
                return false;
            }
        }
        return null;
    }

    private static Integer convertToInteger(Object input) {
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (input instanceof Double || input instanceof Float) {
            return ((Number)input).intValue();
        }
        return null;
    }

    private static Double convertToDouble(Object input) {
        if (input instanceof Double) {
            return (Double)input;
        }
        if (input instanceof Integer || input instanceof Float) {
            return ((Number)input).doubleValue();
        }
        return null;
    }

    private static Float convertToFloat(Object input) {
        if (input instanceof Float) {
            return (Float)input;
        }
        if (input instanceof Integer || input instanceof Double) {
            return Float.valueOf(((Number)input).floatValue());
        }
        return null;
    }

    public static void removeAllGoals(Predicate<Goal> p_262575_, GoalSelector goalSelector) {
        goalSelector.m_148105_().removeIf(p_262564_ -> p_262575_.test(p_262564_.m_26015_()));
    }

    public static class EntityMovementTracker {
        private double prevX = 0.0;
        private double prevY = 0.0;
        private double prevZ = 0.0;

        public boolean isMoving(Entity entity) {
            double currentX = entity.m_20185_();
            double currentY = entity.m_20186_();
            double currentZ = entity.m_20189_();
            boolean moving = currentX != this.prevX || currentY != this.prevY || currentZ != this.prevZ;
            this.prevX = currentX;
            this.prevY = currentY;
            this.prevZ = currentZ;
            return moving;
        }
    }
}

