/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.functional;

import com.copycatsplus.copycats.content.copycat.base.functional.IFunctionalCopycatBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IFunctionalCopycatBlock
extends IWrenchable {
    @Nullable
    default public IFunctionalCopycatBlockEntity getCopycatBlockEntity(BlockGetter worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity == null) {
            return null;
        }
        if (!(blockEntity instanceof IFunctionalCopycatBlockEntity)) {
            return null;
        }
        IFunctionalCopycatBlockEntity functionalCopycatBlockEntity = (IFunctionalCopycatBlockEntity)blockEntity;
        return functionalCopycatBlockEntity;
    }

    default public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        this.onWrenched(state, context);
        return super.onSneakWrenched(state, context);
    }

    default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        IFunctionalCopycatBlockEntity ufte = this.getCopycatBlockEntity((BlockGetter)context.m_43725_(), context.m_8083_());
        if (ufte == null) {
            return InteractionResult.PASS;
        }
        ItemStack consumedItem = ufte.getConsumedItem();
        if (!ufte.hasCustomMaterial()) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (!player.m_7500_()) {
            player.m_150109_().m_150079_(consumedItem);
        }
        context.m_43725_().m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)ufte.getBlockState()));
        ufte.setMaterial(AllBlocks.COPYCAT_BASE.getDefaultState());
        ufte.setConsumedItem(ItemStack.f_41583_);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    default public BlockState getAcceptedBlockState(Level pLevel, BlockPos pPos, ItemStack item, Direction face) {
        Item item2 = item.m_41720_();
        if (!(item2 instanceof BlockItem)) {
            return null;
        }
        BlockItem bi = (BlockItem)item2;
        Block block = bi.m_40614_();
        if (block instanceof CopycatBlock || block instanceof IFunctionalCopycatBlock) {
            return null;
        }
        BlockState appliedState = block.m_49966_();
        boolean hardCodedAllow = this.isAcceptedRegardless(appliedState);
        if (!AllTags.AllBlockTags.COPYCAT_ALLOW.matches(block) && !hardCodedAllow) {
            if (AllTags.AllBlockTags.COPYCAT_DENY.matches(block)) {
                return null;
            }
            if (block instanceof EntityBlock) {
                return null;
            }
            if (block instanceof StairBlock) {
                return null;
            }
            if (pLevel != null) {
                VoxelShape shape = appliedState.m_60808_((BlockGetter)pLevel, pPos);
                if (shape.m_83281_() || !shape.m_83215_().equals((Object)Shapes.m_83144_().m_83215_())) {
                    return null;
                }
                VoxelShape collisionShape = appliedState.m_60812_((BlockGetter)pLevel, pPos);
                if (collisionShape.m_83281_()) {
                    return null;
                }
            }
        }
        if (face != null) {
            Direction.Axis axis = face.m_122434_();
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61374_) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61365_)) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61364_) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)axis);
            }
        }
        return appliedState;
    }

    default public boolean isAcceptedRegardless(BlockState material) {
        return false;
    }

    default public BlockState prepareMaterial(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, BlockState material) {
        return material;
    }

    default public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (player.m_6144_() && player.m_21120_(hand).equals(ItemStack.f_41583_)) {
            IFunctionalCopycatBlockEntity be;
            be.setCTEnabled(!(be = this.getCopycatBlockEntity((BlockGetter)world, pos)).isCTEnabled());
            be.callRedraw();
            return InteractionResult.SUCCESS;
        }
        if (player == null || player != null && !player.m_36326_() && !player.m_5833_()) {
            return InteractionResult.PASS;
        }
        Direction face = ray.m_82434_();
        ItemStack itemInHand = player.m_21120_(hand);
        BlockState materialIn = this.getAcceptedBlockState(world, pos, itemInHand, face);
        if (materialIn != null) {
            materialIn = this.prepareMaterial(world, pos, state, player, hand, ray, materialIn);
        }
        if (materialIn == null) {
            return InteractionResult.PASS;
        }
        BlockState material = materialIn;
        IFunctionalCopycatBlockEntity ufte = this.getCopycatBlockEntity((BlockGetter)world, pos);
        if (ufte == null) {
            return InteractionResult.PASS;
        }
        if (ufte.getMaterial().m_60713_(material.m_60734_())) {
            if (!ufte.cycleMaterial()) {
                return InteractionResult.PASS;
            }
            ufte.getLevel().m_5594_(null, ufte.getBlockPos(), SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 0.95f);
            return InteractionResult.SUCCESS;
        }
        if (ufte.hasCustomMaterial()) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ufte.setMaterial(material);
        ufte.setConsumedItem(itemInHand);
        ufte.getLevel().m_5594_(null, ufte.getBlockPos(), material.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 0.75f);
        if (player.m_7500_()) {
            return InteractionResult.SUCCESS;
        }
        itemInHand.m_41774_(1);
        if (itemInHand.m_41619_()) {
            player.m_21008_(hand, ItemStack.f_41583_);
        }
        return InteractionResult.SUCCESS;
    }

    default public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Player player;
        if (placer == null) {
            return;
        }
        ItemStack offhandItem = placer.m_21120_(InteractionHand.OFF_HAND);
        BlockState appliedState = this.getAcceptedBlockState(worldIn, pos, offhandItem, Direction.m_122382_((Entity)placer)[0]);
        if (appliedState == null) {
            return;
        }
        IFunctionalCopycatBlockEntity ufte = this.getCopycatBlockEntity((BlockGetter)worldIn, pos);
        if (ufte == null) {
            return;
        }
        if (ufte.hasCustomMaterial()) {
            return;
        }
        ufte.setMaterial(appliedState);
        ufte.setConsumedItem(offhandItem);
        if (placer instanceof Player && (player = (Player)placer).m_7500_()) {
            return;
        }
        offhandItem.m_41774_(1);
        if (offhandItem.m_41619_()) {
            placer.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        }
    }

    default public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        IFunctionalCopycatBlockEntity ufte;
        if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        if (!isMoving && (ufte = this.getCopycatBlockEntity((BlockGetter)world, pos)) != null) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)ufte.getConsumedItem());
        }
        world.m_46747_(pos);
    }

    default public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        IFunctionalCopycatBlockEntity ufte;
        if (player.m_7500_() && (ufte = this.getCopycatBlockEntity((BlockGetter)level, pos)) != null) {
            ufte.setConsumedItem(ItemStack.f_41583_);
        }
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        BlockEntity blockEntity = reader.m_7702_(targetPos);
        if (blockEntity instanceof IFunctionalCopycatBlockEntity) {
            IFunctionalCopycatBlockEntity cbe = (IFunctionalCopycatBlockEntity)blockEntity;
            return cbe.getMaterial();
        }
        return Blocks.f_50016_.m_49966_();
    }

    default public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        return false;
    }

    default public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return true;
    }

    default public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return false;
    }

    default public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor wrappedColor() {
        return new WrappedBlockColor();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBlockColor
    implements BlockColor {
        public int m_92566_(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
            return Minecraft.m_91087_().m_91298_().m_92577_(IFunctionalCopycatBlock.getMaterial((BlockGetter)pLevel, pPos), pLevel, pPos, pTintIndex);
        }
    }
}

