/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.model.forge;

import com.copycatsplus.copycats.content.copycat.base.CTCopycatBlockEntity;
import com.copycatsplus.copycats.content.copycat.base.functional.IFunctionalCopycatBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.copycat.FilteredBlockAndTintGetter;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public abstract class CopycatModel
extends BakedModelWrapperWithData {
    public static final ModelProperty<BlockState> MATERIAL_PROPERTY = com.simibubi.create.content.decoration.copycat.CopycatModel.MATERIAL_PROPERTY;
    private static final ModelProperty<OcclusionData> OCCLUSION_PROPERTY = new ModelProperty();
    private static final ModelProperty<ModelData> WRAPPED_DATA_PROPERTY = new ModelProperty();

    public CopycatModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        BlockState material = CopycatModel.getMaterial(blockEntityData);
        builder.with(MATERIAL_PROPERTY, (Object)material);
        Block block = state.m_60734_();
        if (!(block instanceof IFunctionalCopycatBlock)) {
            return builder;
        }
        IFunctionalCopycatBlock copycatBlock = (IFunctionalCopycatBlock)block;
        OcclusionData occlusionData = new OcclusionData();
        this.gatherOcclusionData(world, pos, state, material, occlusionData, copycatBlock);
        builder.with(OCCLUSION_PROPERTY, (Object)occlusionData);
        ModelData wrappedData = CopycatModel.getModelOf(material).getModelData((BlockAndTintGetter)new FilteredBlockAndTintGetter(world, targetPos -> {
            CTCopycatBlockEntity ctbe;
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof CTCopycatBlockEntity && !(ctbe = (CTCopycatBlockEntity)be).isCTEnabled()) {
                return false;
            }
            return copycatBlock.canConnectTexturesToward(world, pos, (BlockPos)targetPos, state);
        }), pos, material, ModelData.EMPTY);
        return builder.with(WRAPPED_DATA_PROPERTY, (Object)wrappedData);
    }

    private void gatherOcclusionData(BlockAndTintGetter world, BlockPos pos, BlockState state, BlockState material, OcclusionData occlusionData, IFunctionalCopycatBlock copycatBlock) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Iterate.directions) {
            BlockPos.MutableBlockPos neighbourPos = mutablePos.m_122159_((Vec3i)pos, face);
            BlockState neighbourState = world.m_8055_((BlockPos)neighbourPos);
            if (state.supportsExternalFaceHiding() && neighbourState.hidesNeighborFace((BlockGetter)world, (BlockPos)neighbourPos, state, face.m_122424_())) {
                occlusionData.occlude(face);
                continue;
            }
            if (!copycatBlock.canFaceBeOccluded(state, face) || Block.m_152444_((BlockState)material, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)neighbourPos)) continue;
            occlusionData.occlude(face);
        }
    }

    @NotNull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @NotNull RandomSource rand, @NotNull ModelData data, RenderType renderType) {
        Block block;
        IFunctionalCopycatBlock ccb;
        Block block2;
        if (side != null && (block2 = state.m_60734_()) instanceof IFunctionalCopycatBlock && (ccb = (IFunctionalCopycatBlock)block2).shouldFaceAlwaysRender(state, side)) {
            return Collections.emptyList();
        }
        BlockState material = CopycatModel.getMaterial(data);
        OcclusionData occlusionData = (OcclusionData)data.get(OCCLUSION_PROPERTY);
        if (occlusionData != null && occlusionData.isOccluded(side)) {
            return super.getQuads(state, side, rand, data, renderType);
        }
        ModelData wrappedData = (ModelData)data.get(WRAPPED_DATA_PROPERTY);
        if (wrappedData == null) {
            wrappedData = ModelData.EMPTY;
        }
        if (renderType != null && !Minecraft.m_91087_().m_91289_().m_110910_(material).getRenderTypes(material, rand, wrappedData).contains(renderType)) {
            return super.getQuads(state, side, rand, data, renderType);
        }
        List<BakedQuad> croppedQuads = this.getCroppedQuads(state, side, rand, material, wrappedData, renderType);
        if (side == null && (block = state.m_60734_()) instanceof IFunctionalCopycatBlock) {
            IFunctionalCopycatBlock ccb2 = (IFunctionalCopycatBlock)block;
            boolean immutable = true;
            for (Direction nonOcclusionSide : Iterate.directions) {
                if (!ccb2.shouldFaceAlwaysRender(state, nonOcclusionSide)) continue;
                if (immutable) {
                    croppedQuads = new ArrayList<BakedQuad>(croppedQuads);
                    immutable = false;
                }
                croppedQuads.addAll(this.getCroppedQuads(state, nonOcclusionSide, rand, material, wrappedData, renderType));
            }
        }
        return croppedQuads;
    }

    public abstract List<BakedQuad> getCroppedQuads(BlockState var1, Direction var2, RandomSource var3, BlockState var4, ModelData var5, RenderType var6);

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        BlockState material = CopycatModel.getMaterial(data);
        ModelData wrappedData = (ModelData)data.get(WRAPPED_DATA_PROPERTY);
        if (wrappedData == null) {
            wrappedData = ModelData.EMPTY;
        }
        return CopycatModel.getModelOf(material).getParticleIcon(wrappedData);
    }

    public static BlockState getMaterial(ModelData data) {
        BlockState material = data == null ? null : (BlockState)data.get(MATERIAL_PROPERTY);
        return material == null ? AllBlocks.COPYCAT_BASE.getDefaultState() : material;
    }

    public static BakedModel getModelOf(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    public static class OcclusionData {
        private final boolean[] occluded = new boolean[6];

        public void occlude(Direction face) {
            this.occluded[face.m_122411_()] = true;
        }

        public boolean isOccluded(Direction face) {
            return face != null && this.occluded[face.m_122411_()];
        }
    }
}

