/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.multistate;

import java.util.function.Consumer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.NotNull;

public enum BlockStateTransform implements StringRepresentable
{
    ABCD,
    BCDA,
    CDAB,
    DABC,
    ADCB,
    DCBA,
    CBAD,
    BADC;


    public BlockStateTransform getClockwise() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ABCD -> BCDA;
            case BCDA -> CDAB;
            case CDAB -> DABC;
            case DABC -> ABCD;
            case ADCB -> DCBA;
            case DCBA -> CBAD;
            case CBAD -> BADC;
            case BADC -> ADCB;
        };
    }

    public BlockStateTransform getCounterClockwise() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ABCD -> DABC;
            case BCDA -> ABCD;
            case CDAB -> BCDA;
            case DABC -> CDAB;
            case ADCB -> BADC;
            case DCBA -> ADCB;
            case CBAD -> DCBA;
            case BADC -> CBAD;
        };
    }

    public BlockStateTransform flipX() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ABCD -> BADC;
            case BCDA -> CBAD;
            case CDAB -> DCBA;
            case DABC -> ADCB;
            case ADCB -> DABC;
            case DCBA -> CDAB;
            case CBAD -> BCDA;
            case BADC -> ABCD;
        };
    }

    public BlockStateTransform flipZ() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ABCD -> DCBA;
            case BCDA -> ADCB;
            case CDAB -> BADC;
            case DABC -> CBAD;
            case ADCB -> BCDA;
            case DCBA -> ABCD;
            case CBAD -> DABC;
            case BADC -> CDAB;
        };
    }

    @NotNull
    public String m_7912_() {
        return this.name().toLowerCase();
    }

    public void undoTransform(Consumer<Rotation> rotate, Consumer<Mirror> mirror) {
        switch (this) {
            case ABCD: {
                break;
            }
            case BCDA: {
                rotate.accept(Rotation.CLOCKWISE_90);
                break;
            }
            case CDAB: {
                rotate.accept(Rotation.CLOCKWISE_180);
                break;
            }
            case DABC: {
                rotate.accept(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            case ADCB: {
                mirror.accept(Mirror.FRONT_BACK);
                rotate.accept(Rotation.CLOCKWISE_90);
                break;
            }
            case DCBA: {
                mirror.accept(Mirror.FRONT_BACK);
                break;
            }
            case CBAD: {
                mirror.accept(Mirror.FRONT_BACK);
                rotate.accept(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            case BADC: {
                mirror.accept(Mirror.FRONT_BACK);
                rotate.accept(Rotation.CLOCKWISE_180);
            }
        }
    }
}

