/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.slab;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.content.copycat.base.ICopycatWithWrappedBlock;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.content.copycat.base.multistate.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.content.copycat.base.multistate.WaterloggedMultiStateCopycatBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatSlabBlock
extends WaterloggedMultiStateCopycatBlock
implements ICopycatWithWrappedBlock<Block> {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<SlabType> SLAB_TYPE = BlockStateProperties.f_61397_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CopycatSlabBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_(SLAB_TYPE, (Comparable)SlabType.BOTTOM));
    }

    @Override
    public int maxMaterials() {
        return 2;
    }

    @Override
    public Vec3i vectorScale(BlockState state) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3i(2, 1, 1);
            case Direction.Axis.Y -> new Vec3i(1, 2, 1);
            case Direction.Axis.Z -> new Vec3i(1, 1, 2);
        };
    }

    @Override
    public String getPropertyFromInteraction(BlockState state, BlockGetter level, Vec3i hitLocation, BlockPos blockPos, Direction facing, Vec3 unscaledHit) {
        if (hitLocation.m_123304_((Direction.Axis)state.m_61143_(AXIS)) > 0) {
            return SlabType.TOP.m_7912_();
        }
        return SlabType.BOTTOM.m_7912_();
    }

    @Override
    public Vec3i getVectorFromProperty(BlockState state, String property) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (property.equals(SlabType.TOP.m_7912_())) {
                    yield new Vec3i(1, 0, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Y -> {
                if (property.equals(SlabType.TOP.m_7912_())) {
                    yield new Vec3i(0, 1, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Z -> property.equals(SlabType.TOP.m_7912_()) ? new Vec3i(0, 0, 1) : new Vec3i(0, 0, 0);
        };
    }

    @Override
    public boolean partExists(BlockState state, String property) {
        SlabType slabType = (SlabType)state.m_61143_(SLAB_TYPE);
        if (property.equals(SlabType.BOTTOM.m_7912_())) {
            return slabType == SlabType.DOUBLE || slabType == SlabType.BOTTOM;
        }
        if (property.equals(SlabType.TOP.m_7912_())) {
            return slabType == SlabType.DOUBLE || slabType == SlabType.TOP;
        }
        return false;
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(SlabType.BOTTOM.m_7912_(), SlabType.TOP.m_7912_());
    }

    @Override
    public Block getWrappedBlock() {
        return Blocks.f_50405_;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!player.m_6144_() && player.m_36326_()) {
            ItemStack heldItem = player.m_21120_(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (state.m_61143_(SLAB_TYPE) != SlabType.DOUBLE) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        String property = this.getProperty(state, (BlockGetter)context.m_43725_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), true);
        if (!this.partExists(state, property)) {
            return InteractionResult.FAIL;
        }
        if (world instanceof ServerLevel) {
            if (player != null) {
                List drops = Block.m_49874_((BlockState)((BlockState)this.m_49966_().m_61124_(SLAB_TYPE, (Comparable)(property.equals(SlabType.BOTTOM.m_7912_()) ? SlabType.BOTTOM : SlabType.TOP))), (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                this.withBlockEntityDo((BlockGetter)world, pos, ufte -> {
                    drops.add(ufte.getMaterialItemStorage().getMaterialItem(property).consumedItem());
                    ufte.setMaterial(property, AllBlocks.COPYCAT_BASE.getDefaultState());
                    ufte.setConsumedItem(property, ItemStack.f_41583_);
                });
                if (!player.m_7500_()) {
                    for (ItemStack drop : drops) {
                        player.m_150109_().m_150079_(drop);
                    }
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_(SLAB_TYPE, (Comparable)(property.equals(SlabType.BOTTOM.m_7912_()) ? SlabType.TOP : SlabType.BOTTOM))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean isIgnoredConnectivitySide(String property, BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        BlockState toState = reader.m_8055_(toPos);
        if (reader instanceof ScaledBlockAndTintGetter) {
            ScaledBlockAndTintGetter scaledReader = (ScaledBlockAndTintGetter)reader;
            BlockPos fromTruePos = scaledReader.getTruePos(fromPos);
            BlockPos toTruePos = scaledReader.getTruePos(toPos);
            return fromTruePos.equals((Object)toTruePos);
        }
        return !toState.m_60713_((Block)this);
    }

    @Override
    public boolean canConnectTexturesToward(String property, BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (reader instanceof ScaledBlockAndTintGetter) {
            BlockPos toTruePos;
            ScaledBlockAndTintGetter scaledReader = (ScaledBlockAndTintGetter)reader;
            BlockPos fromTruePos = scaledReader.getTruePos(fromPos);
            return !fromTruePos.equals((Object)(toTruePos = scaledReader.getTruePos(toPos))) && toState.m_60713_((Block)this);
        }
        return toState.m_60713_((Block)this);
    }

    @Override
    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return CopycatSlabBlock.getFaceShape(state, face).hasContact();
    }

    @Override
    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !CopycatSlabBlock.getFaceShape(state, face).hasContact();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            return (BlockState)((BlockState)state.m_61124_(SLAB_TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        Direction.Axis axis = context.m_7820_().m_122434_();
        boolean flag = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (context.m_43720_().f_82479_ - (double)blockPos.m_123341_() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (context.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> context.m_43720_().f_82481_ - (double)blockPos.m_123343_() > 0.5;
        };
        Direction clickedFace = context.m_43719_();
        return (BlockState)((BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)axis)).m_61124_(SLAB_TYPE, (Comparable)(clickedFace == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || clickedFace.m_122434_() != axis && !flag ? SlabType.BOTTOM : SlabType.TOP));
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        SlabType slabtype = (SlabType)pState.m_61143_(SLAB_TYPE);
        Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
        if (slabtype != SlabType.DOUBLE && itemstack.m_150930_(this.m_5456_())) {
            boolean flag = switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> {
                    if (pUseContext.m_43720_().f_82479_ - (double)pUseContext.m_8083_().m_123341_() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (pUseContext.m_43720_().f_82480_ - (double)pUseContext.m_8083_().m_123342_() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> pUseContext.m_43720_().f_82481_ - (double)pUseContext.m_8083_().m_123343_() > 0.5;
            };
            Direction direction = pUseContext.m_43719_();
            if (slabtype == SlabType.BOTTOM) {
                return direction == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || flag;
            }
            return direction == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE) || !flag;
        }
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{AXIS}).m_61104_(new Property[]{SLAB_TYPE}));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return super.m_7357_(pState, pLevel, pPos, pType);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        VoxelShape shapeOverride = CopycatSlabBlock.multiPlatformGetShape(pState, pLevel, pPos, pContext);
        if (shapeOverride != null) {
            return shapeOverride;
        }
        SlabType type = (SlabType)pState.m_61143_(SLAB_TYPE);
        Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
        if (type == SlabType.DOUBLE) {
            return Shapes.m_83144_();
        }
        if (type == SlabType.BOTTOM) {
            return CCShapes.CASING_8PX.get(axis);
        }
        return CCShapes.CASING_8PX_TOP.get(axis);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if ((neighborState.m_60734_() instanceof SlabBlock || neighborState.m_60734_() instanceof CopycatSlabBlock) && CopycatSlabBlock.getMaterial(level, pos).m_60719_(CopycatSlabBlock.getMaterial(level, pos.m_121945_(dir)), dir.m_122424_())) {
            return CopycatSlabBlock.getFaceShape(state, dir) == CopycatSlabBlock.getFaceShape(neighborState, dir.m_122424_());
        }
        return CopycatSlabBlock.getFaceShape(state, dir) == FaceShape.FULL && CopycatSlabBlock.getMaterial(level, pos).m_60719_(neighborState, dir.m_122424_());
    }

    @Override
    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        state = super.m_6843_(state, rot);
        return CopycatSlabBlock.setApparentDirection(state, rot.m_55954_(CopycatSlabBlock.getApparentDirection(state)));
    }

    @Override
    public void rotate(@NotNull BlockState state, @NotNull MultiStateCopycatBlockEntity be, Rotation rotation) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (axis == Direction.Axis.Y) {
            return;
        }
        if (rotation == Rotation.CLOCKWISE_90 && axis == Direction.Axis.X || rotation == Rotation.CLOCKWISE_180 || rotation == Rotation.COUNTERCLOCKWISE_90 && axis == Direction.Axis.Z) {
            be.getMaterialItemStorage().remapStorage(s -> s.equals(Half.BOTTOM.m_7912_()) ? Half.TOP.m_7912_() : Half.BOTTOM.m_7912_());
        }
    }

    @Override
    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirrorIn) {
        state = super.m_6943_(state, mirrorIn);
        return state.m_60717_(mirrorIn.m_54846_(CopycatSlabBlock.getApparentDirection(state)));
    }

    @Override
    public void mirror(@NotNull BlockState state, @NotNull MultiStateCopycatBlockEntity be, Mirror mirror) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (axis == Direction.Axis.Y) {
            return;
        }
        if (mirror == Mirror.FRONT_BACK && axis == Direction.Axis.Z || mirror == Mirror.LEFT_RIGHT && axis == Direction.Axis.X) {
            be.getMaterialItemStorage().remapStorage(s -> s.equals(Half.BOTTOM.m_7912_()) ? Half.TOP.m_7912_() : Half.BOTTOM.m_7912_());
        }
    }

    public static FaceShape getFaceShape(BlockState state, Direction face) {
        SlabType slab = (SlabType)state.m_61143_(SLAB_TYPE);
        if (state.m_61143_(AXIS) != face.m_122434_()) {
            return FaceShape.forSlabSide(slab);
        }
        return switch (slab) {
            default -> throw new IncompatibleClassChangeError();
            case SlabType.TOP -> FaceShape.fullOrNone(face.m_122421_() == Direction.AxisDirection.POSITIVE);
            case SlabType.BOTTOM -> FaceShape.fullOrNone(face.m_122421_() == Direction.AxisDirection.NEGATIVE);
            case SlabType.DOUBLE -> FaceShape.FULL;
        };
    }

    public static Direction getApparentDirection(BlockState state) {
        return Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)), (Direction.AxisDirection)(state.m_61143_(SLAB_TYPE) == SlabType.BOTTOM ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
    }

    public static BlockState setApparentDirection(BlockState state, Direction direction) {
        SlabType type = (SlabType)state.m_61143_(SLAB_TYPE);
        if (type == SlabType.DOUBLE) {
            return (BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_());
        }
        if (CopycatSlabBlock.getApparentDirection(state).m_122421_() != direction.m_122421_()) {
            return (BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_())).m_61124_(SLAB_TYPE, (Comparable)(type == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM));
        }
        return (BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_());
    }

    private static enum FaceShape {
        FULL,
        TOP,
        BOTTOM,
        NONE;


        public static FaceShape forSlabSide(SlabType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case SlabType.TOP -> TOP;
                case SlabType.BOTTOM -> BOTTOM;
                case SlabType.DOUBLE -> FULL;
            };
        }

        public static FaceShape fullOrNone(boolean value) {
            return value ? FULL : NONE;
        }

        public static boolean canConnect(FaceShape shape1, FaceShape shape2) {
            return shape1 == shape2 || shape1 == FULL && shape2 != NONE || shape2 == FULL && shape1 != NONE;
        }

        public boolean hasContact() {
            return this != NONE;
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CCBlocks.COPYCAT_SLAB.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> CCBlocks.COPYCAT_SLAB.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)), dir -> world.m_8055_(pos.m_121945_(dir)).m_60767_().m_76336_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            if (((SlabType)state.m_61143_(SLAB_TYPE)).equals((Object)SlabType.DOUBLE)) {
                return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)((BlockState)s.m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)))).m_61124_(SLAB_TYPE, (Comparable)SlabType.BOTTOM));
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)((BlockState)s.m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)))).m_61124_(SLAB_TYPE, (Comparable)((SlabType)state.m_61143_(SLAB_TYPE))));
        }
    }
}

