/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.slope;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.content.copycat.MathHelper;
import com.copycatsplus.copycats.content.copycat.base.CTWaterloggedCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.ICustomCTBlocking;
import com.copycatsplus.copycats.content.copycat.base.IStateType;
import com.copycatsplus.copycats.utility.shape.NoneVoxelShape;
import com.copycatsplus.copycats.utility.shape.VoxelUtils;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatSlopeBlock
extends CTWaterloggedCopycatBlock
implements IStateType,
ICustomCTBlocking {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CopycatSlopeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!player.m_6144_() && player.m_36326_()) {
            ItemStack heldItem = player.m_21120_(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Half half = (Half)state.m_61143_(HALF);
        BlockState toState = reader.m_8055_(toPos);
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return false;
        }
        Direction connectFace = MathHelper.DirectionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (connectFace == null) {
            return false;
        }
        if (toState.m_60713_((Block)this)) {
            if (toState.m_61143_((Property)FACING) == direction && toState.m_61143_(HALF) == half) {
                return false;
            }
            return direction != connectFace || connectFace != ((Direction)toState.m_61143_((Property)FACING)).m_122424_();
        }
        return !(direction == connectFace || half == Half.TOP && connectFace == Direction.UP || half == Half.BOTTOM && connectFace == Direction.DOWN);
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Half half = (Half)state.m_61143_(HALF);
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction face = MathHelper.DirectionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (face == null) {
            return true;
        }
        if (toState.m_60713_((Block)this)) {
            try {
                return toState.m_61143_((Property)FACING) == facing && toState.m_61143_(HALF) == half && face.m_122434_().m_122479_() && face.m_122434_() != facing.m_122434_() || face == facing && face == ((Direction)toState.m_61143_((Property)FACING)).m_122424_();
            }
            catch (IllegalStateException ignored) {
                return false;
            }
        }
        return face == facing || half == Half.TOP && face == Direction.UP || half == Half.BOTTOM && face == Direction.DOWN;
    }

    @Override
    public Optional<Boolean> isCTBlocked(BlockAndTintGetter reader, BlockState state, BlockPos pos, BlockPos connectingPos, BlockPos blockingPos, Direction face) {
        if (reader.m_8055_(blockingPos).m_60713_((Block)this)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Half half = (Half)state.m_61143_(HALF);
        if (face == facing) {
            return true;
        }
        if (face == facing.m_122424_()) {
            return false;
        }
        if (half == Half.TOP) {
            return face != Direction.DOWN;
        }
        return face != Direction.UP;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !this.canFaceBeOccluded(state, face);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        Direction facing = context.m_8125_();
        Half half = context.m_43719_() == Direction.DOWN ? Half.TOP : (context.m_43719_() == Direction.UP ? Half.BOTTOM : (context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5 ? Half.TOP : Half.BOTTOM));
        return (BlockState)((BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)facing)).m_61124_(HALF, (Comparable)half);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{FACING, HALF}));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        Vec3[] vec3Array;
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        boolean isBottom = pState.m_61143_(HALF) == Half.BOTTOM;
        switch (facing) {
            case WEST: {
                Vec3[] vec3Array2 = new Vec3[8];
                vec3Array2[0] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array2[1] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array2[2] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array2[3] = new Vec3(0.0, (double)(isBottom ? 1 : 0), 0.0);
                vec3Array2[4] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array2[5] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array2[6] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array = vec3Array2;
                vec3Array2[7] = new Vec3(0.0, (double)(isBottom ? 1 : 0), 1.0);
                break;
            }
            case EAST: {
                Vec3[] vec3Array3 = new Vec3[8];
                vec3Array3[0] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array3[1] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array3[2] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array3[3] = new Vec3(1.0, (double)(isBottom ? 1 : 0), 1.0);
                vec3Array3[4] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array3[5] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array3[6] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array = vec3Array3;
                vec3Array3[7] = new Vec3(1.0, (double)(isBottom ? 1 : 0), 0.0);
                break;
            }
            case NORTH: {
                Vec3[] vec3Array4 = new Vec3[8];
                vec3Array4[0] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array4[1] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array4[2] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array4[3] = new Vec3(0.0, (double)(isBottom ? 1 : 0), 0.0);
                vec3Array4[4] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array4[5] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array4[6] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array = vec3Array4;
                vec3Array4[7] = new Vec3(1.0, (double)(isBottom ? 1 : 0), 0.0);
                break;
            }
            case SOUTH: {
                Vec3[] vec3Array5 = new Vec3[8];
                vec3Array5[0] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array5[1] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array5[2] = new Vec3(1.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array5[3] = new Vec3(1.0, (double)(isBottom ? 1 : 0), 1.0);
                vec3Array5[4] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array5[5] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 1.0);
                vec3Array5[6] = new Vec3(0.0, (double)(!isBottom ? 1 : 0), 0.0);
                vec3Array = vec3Array5;
                vec3Array5[7] = new Vec3(0.0, (double)(isBottom ? 1 : 0), 1.0);
                break;
            }
            default: {
                throw new AssertionError((Object)"Direction shouldn't appear as this is a horizontal facing block only");
            }
        }
        Vec3[] triangleVertices = vec3Array;
        Vec3[] shape = VoxelUtils.create12Edges(triangleVertices);
        return new NoneVoxelShape(isBottom ? CCShapes.SLOPE_BOTTOM.get(facing) : CCShapes.SLOPE_TOP.get(facing), shape);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this) && CopycatSlopeBlock.getMaterial((BlockGetter)level, (BlockPos)pos).m_60719_(CopycatSlopeBlock.getMaterial((BlockGetter)level, (BlockPos)pos.m_121945_(dir)), dir.m_122424_())) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            Half half = (Half)state.m_61143_(HALF);
            return neighborState.m_61143_((Property)FACING) == facing && neighborState.m_61143_(HALF) == half && dir.m_122434_().m_122479_() && dir.m_122434_() != facing.m_122434_();
        }
        return false;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pMirror.m_54848_((Direction)pState.m_61143_((Property)FACING)));
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction> {
        private PlacementHelper() {
            super(arg_0 -> CCBlocks.COPYCAT_SLOPE.has(arg_0), state -> ((Direction)state.m_61143_((Property)FACING)).m_122427_().m_122434_(), (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof CopycatSlopeBlock;
        }
    }
}

