/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.slope;

import com.copycatsplus.copycats.content.copycat.base.model.SimpleCopycatPart;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.Assembler;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.GlobalTransform;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableCullFace;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.quad.QuadSlope;
import com.copycatsplus.copycats.content.copycat.slope.CopycatSlopeBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;

public class CopycatSlopeModel
implements SimpleCopycatPart {
    private final boolean enhanced;

    public CopycatSlopeModel(boolean enhanced) {
        this.enhanced = enhanced;
    }

    @Override
    public void emitCopycatQuads(BlockState state, Assembler.CopycatRenderContext<?, ?> context, BlockState material) {
        Direction facing = (Direction)state.m_61143_((Property)CopycatSlopeBlock.FACING);
        Half half = (Half)state.m_61143_(CopycatSlopeBlock.HALF);
        int rot = (int)facing.m_122435_();
        boolean flipY = half == Half.TOP;
        GlobalTransform transform = t -> t.flipY(flipY).rotateY(rot);
        CopycatSlopeModel.assembleSlope(context, transform, 0.0, 16.0, this.enhanced);
    }

    public static void assembleSlope(Assembler.CopycatRenderContext<?, ?> context, GlobalTransform transform, double minHeight, double maxHeight, boolean enhanced) {
        if (minHeight == 0.0) {
            if (enhanced) {
                CopycatSlopeModel.assembleTriangularSlope(context, transform, maxHeight, CopycatSlopeModel.getMarginForHeight(maxHeight));
            } else {
                CopycatSlopeModel.assembleTriangularSlope(context, transform, maxHeight);
            }
        } else if (enhanced) {
            CopycatSlopeModel.assembleTrapezoidSlope(context, transform, minHeight, maxHeight, Math.min(2.0, CopycatSlopeModel.getMarginForHeight(maxHeight)));
        } else {
            CopycatSlopeModel.assembleTrapezoidSlope(context, transform, minHeight, maxHeight);
        }
    }

    private static double getMarginForHeight(double maxHeight) {
        if (maxHeight <= 2.5) {
            return 0.5;
        }
        if (maxHeight <= 4.5) {
            return 1.0;
        }
        if (maxHeight <= 8.5) {
            return 2.0;
        }
        return 3.0;
    }

    public static void assembleTriangularSlope(Assembler.CopycatRenderContext<?, ?> context, GlobalTransform transform, double maxHeight) {
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(16.0, 16.0, 16.0), Assembler.cull(MutableCullFace.NORTH), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(0.0, 16.0, 0.0, maxHeight, b))));
    }

    public static void assembleTrapezoidSlope(Assembler.CopycatRenderContext<?, ?> context, GlobalTransform transform, double minHeight, double maxHeight) {
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(16.0, 16.0, 16.0), Assembler.cull(0), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(0.0, 16.0, minHeight, maxHeight, b))));
    }

    public static void assembleTriangularSlope(Assembler.CopycatRenderContext<?, ?> context, GlobalTransform transform, double maxHeight, double margin) {
        double angleBottom = Math.toDegrees(Math.atan2(maxHeight, 16.0));
        double marginAdjBottom = margin / Math.tan(Math.toRadians(angleBottom) / 2.0);
        double angleTop = Math.toDegrees(Math.atan2(16.0, maxHeight));
        double marginAdjTop = margin / Math.tan(Math.toRadians(angleTop) / 2.0);
        double halfLength = Math.sqrt(maxHeight * maxHeight + 256.0) / 2.0;
        double midLengthBottom = halfLength - marginAdjBottom;
        double marginAdjExcessBottom = marginAdjBottom - Math.floor(marginAdjBottom);
        double midLengthTop = halfLength - marginAdjTop;
        double marginAdjExcessTop = marginAdjTop - Math.floor(marginAdjTop);
        double alignedLengthBottom = Math.abs(Math.floor(midLengthBottom + marginAdjExcessBottom) - marginAdjExcessBottom);
        double alignedLengthTop = Math.floor(midLengthTop + marginAdjExcessTop) - marginAdjExcessTop;
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(16.0, 16.0, marginAdjBottom), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(0.0, marginAdjBottom, 0.0, margin, b))));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, marginAdjBottom), Assembler.aabb(16.0, 16.0, 16.0 - margin - marginAdjBottom).move(0.0, 0.0, marginAdjBottom), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(marginAdjBottom, 16.0 - margin, margin, maxHeight - marginAdjTop, b))));
        if (maxHeight == 16.0) {
            Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 16.0 - margin), Assembler.aabb(16.0, 16.0, margin).move(0.0, 0.0, 16.0 - margin), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(16.0 - margin, 16.0, maxHeight - marginAdjTop, maxHeight, b))));
        } else {
            Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 16.0 - margin), Assembler.aabb(16.0, maxHeight / 2.0, margin).move(0.0, 0.0, 16.0 - margin), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH));
            Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 16.0 - maxHeight / 2.0, 16.0 - margin), Assembler.aabb(16.0, maxHeight / 2.0, margin).move(0.0, 16.0 - maxHeight / 2.0, 16.0 - margin), Assembler.cull(MutableCullFace.UP | MutableCullFace.DOWN | MutableCullFace.NORTH), Assembler.scale(Assembler.pivot(16.0, 16.0, 16.0), Assembler.scale(1.0, 32.0 / maxHeight, 1.0)), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(16.0 - margin, 16.0, 16.0 - marginAdjTop / maxHeight * 32.0, 16.0, b))), Assembler.scale(Assembler.pivot(16.0, 16.0, 16.0), Assembler.scale(1.0, maxHeight / 32.0, 1.0)), Assembler.translate(0.0, -16.0 + maxHeight, 0.0));
        }
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(16.0, 16.0, marginAdjBottom), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.updateUV(Assembler.slope(Direction.DOWN, (a, b) -> QuadSlope.map(0.0, marginAdjBottom, 0.0, margin, b))), Assembler.translate(0.0, -16.0, 0.0), Assembler.rotate(Assembler.pivot(0.0, 0.0, 0.0), Assembler.angle(-angleBottom, 0.0, 0.0)));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, maxHeight - margin, 16.0 - alignedLengthBottom), Assembler.aabb(16.0, margin, alignedLengthBottom).move(0.0, 16.0 - margin, marginAdjBottom), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.scale(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.scale(1.0, 1.0, midLengthBottom / alignedLengthBottom)), Assembler.translate(0.0, 0.0, -halfLength), Assembler.rotate(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.angle(-angleBottom, 0.0, 0.0)));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, maxHeight - margin, 16.0 - alignedLengthTop), Assembler.aabb(16.0, margin, alignedLengthTop).move(0.0, 16.0 - margin, 16.0 - marginAdjTop - alignedLengthTop), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.scale(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.scale(1.0, 1.0, midLengthTop / alignedLengthTop)), Assembler.translate(0.0, 0.0, -marginAdjTop), Assembler.rotate(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.angle(-angleBottom, 0.0, 0.0)));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 16.0 - marginAdjTop), Assembler.aabb(16.0, 16.0, marginAdjTop).move(0.0, 0.0, 16.0 - marginAdjTop), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.updateUV(Assembler.slope(Direction.DOWN, (a, b) -> QuadSlope.map(16.0 - marginAdjTop, 16.0, margin, 0.0, b))), Assembler.translate(0.0, -16.0 + maxHeight, 0.0), Assembler.rotate(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.angle(-angleBottom, 0.0, 0.0)));
    }

    public static void assembleTrapezoidSlope(Assembler.CopycatRenderContext<?, ?> context, GlobalTransform transform, double minHeight, double maxHeight, double margin) {
        double angleBottom = Math.toDegrees(Math.atan2(maxHeight - minHeight, 16.0)) + 90.0;
        double marginAdjBottom = margin / Math.tan(Math.toRadians(angleBottom) / 2.0);
        double angleTop = Math.toDegrees(Math.atan2(16.0, maxHeight - minHeight));
        double marginAdjTop = margin / Math.tan(Math.toRadians(angleTop) / 2.0);
        double halfLength = Math.sqrt((maxHeight - minHeight) * (maxHeight - minHeight) + 256.0) / 2.0;
        double midLengthBottom = halfLength - marginAdjBottom;
        double marginAdjExcessBottom = marginAdjBottom - Math.floor(marginAdjBottom);
        double midLengthTop = halfLength - marginAdjTop;
        double marginAdjExcessTop = marginAdjTop - Math.floor(marginAdjTop);
        double alignedLengthBottom = Math.abs(Math.floor(midLengthBottom + marginAdjExcessBottom) - marginAdjExcessBottom);
        double alignedLengthTop = Math.floor(midLengthTop + marginAdjExcessTop) - marginAdjExcessTop;
        if (minHeight == 16.0 || minHeight == 0.0) {
            Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(16.0, 16.0, margin), Assembler.cull(MutableCullFace.UP | MutableCullFace.SOUTH), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(0.0, margin, minHeight, minHeight - marginAdjBottom, b))));
        } else {
            Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(16.0, minHeight / 2.0, margin).move(0.0, 0.0, 0.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.SOUTH));
            Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(16.0, minHeight / 2.0, margin).move(0.0, 16.0 - minHeight / 2.0, 0.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.DOWN | MutableCullFace.SOUTH), Assembler.scale(Assembler.pivot(0.0, 0.0, 0.0), Assembler.scale(1.0, 32.0 / minHeight, 1.0)), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(0.0, margin, 16.0, 16.0 - marginAdjBottom / minHeight * 32.0, b))), Assembler.scale(Assembler.pivot(0.0, 0.0, 0.0), Assembler.scale(1.0, minHeight / 32.0, 1.0)), Assembler.translate(0.0, minHeight / 2.0, 0.0));
        }
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, margin), Assembler.aabb(16.0, 16.0, 16.0 - margin * 2.0).move(0.0, 0.0, margin), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(margin, 16.0 - margin, minHeight - marginAdjBottom, maxHeight - marginAdjTop, b))));
        if (maxHeight == 16.0 || maxHeight == 0.0) {
            Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 16.0 - margin), Assembler.aabb(16.0, 16.0, margin).move(0.0, 0.0, 16.0 - margin), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(16.0 - margin, 16.0, maxHeight - marginAdjTop, maxHeight, b))));
        } else {
            Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 16.0 - margin), Assembler.aabb(16.0, maxHeight / 2.0, margin).move(0.0, 0.0, 16.0 - margin), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH));
            Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 16.0 - maxHeight / 2.0, 16.0 - margin), Assembler.aabb(16.0, maxHeight / 2.0, margin).move(0.0, 16.0 - maxHeight / 2.0, 16.0 - margin), Assembler.cull(MutableCullFace.UP | MutableCullFace.DOWN | MutableCullFace.NORTH), Assembler.scale(Assembler.pivot(16.0, 16.0, 16.0), Assembler.scale(1.0, 32.0 / maxHeight, 1.0)), Assembler.updateUV(Assembler.slope(Direction.UP, (a, b) -> QuadSlope.map(16.0 - margin, 16.0, 16.0 - marginAdjTop / maxHeight * 32.0, 16.0, b))), Assembler.scale(Assembler.pivot(16.0, 16.0, 16.0), Assembler.scale(1.0, maxHeight / 32.0, 1.0)), Assembler.translate(0.0, -16.0 + maxHeight, 0.0));
        }
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(16.0, 16.0, marginAdjBottom), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.updateUV(Assembler.slope(Direction.DOWN, (a, b) -> QuadSlope.map(0.0, marginAdjBottom, 0.0, margin, b))), Assembler.translate(0.0, -16.0 + minHeight, 0.0), Assembler.rotate(Assembler.pivot(0.0, minHeight, 0.0), Assembler.angle(90.0 - angleBottom, 0.0, 0.0)));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, maxHeight - margin, 16.0 - alignedLengthBottom), Assembler.aabb(16.0, margin, alignedLengthBottom).move(0.0, 16.0 - margin, marginAdjBottom), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.scale(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.scale(1.0, 1.0, midLengthBottom / alignedLengthBottom)), Assembler.translate(0.0, 0.0, -halfLength), Assembler.rotate(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.angle(90.0 - angleBottom, 0.0, 0.0)));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, maxHeight - margin, 16.0 - alignedLengthTop), Assembler.aabb(16.0, margin, alignedLengthTop).move(0.0, 16.0 - margin, 16.0 - marginAdjTop - alignedLengthTop), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.scale(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.scale(1.0, 1.0, midLengthTop / alignedLengthTop)), Assembler.translate(0.0, 0.0, -marginAdjTop), Assembler.rotate(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.angle(90.0 - angleBottom, 0.0, 0.0)));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 16.0 - marginAdjTop), Assembler.aabb(16.0, 16.0, marginAdjTop).move(0.0, 0.0, 16.0 - marginAdjTop), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.SOUTH), Assembler.updateUV(Assembler.slope(Direction.DOWN, (a, b) -> QuadSlope.map(16.0 - marginAdjTop, 16.0, margin, 0.0, b))), Assembler.translate(0.0, -16.0 + maxHeight, 0.0), Assembler.rotate(Assembler.pivot(16.0, maxHeight, 16.0), Assembler.angle(90.0 - angleBottom, 0.0, 0.0)));
    }
}

