/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.stairs;

import com.copycatsplus.copycats.content.copycat.base.model.SimpleCopycatPart;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.Assembler;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.GlobalTransform;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableCullFace;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class CopycatStairsModel
implements SimpleCopycatPart {
    @Override
    public void emitCopycatQuads(BlockState state, Assembler.CopycatRenderContext<?, ?> context, BlockState material) {
        int facing = (int)((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122435_();
        boolean top = state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        switch (shape) {
            case STRAIGHT: {
                GlobalTransform transform = t -> t.rotateY(facing).flipY(top);
                CopycatStairsModel.assembleStraight(context, transform);
                break;
            }
            case INNER_LEFT: 
            case INNER_RIGHT: {
                boolean flipX = shape == StairsShape.INNER_RIGHT;
                GlobalTransform transform = t -> t.flipX(flipX).rotateY(facing).flipY(top);
                CopycatStairsModel.assembleInnerLeft(context, transform);
                break;
            }
            case OUTER_LEFT: 
            case OUTER_RIGHT: {
                boolean flipX = shape == StairsShape.OUTER_RIGHT;
                GlobalTransform transform = t -> t.flipX(flipX).rotateY(facing).flipY(top);
                CopycatStairsModel.assembleOuterLeft(context, transform);
            }
        }
    }

    public static void assembleStraight(Assembler.CopycatRenderContext<?, ?> context, GlobalTransform transform) {
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(16.0, 4.0, 8.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.SOUTH));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 4.0, 0.0), Assembler.aabb(16.0, 4.0, 8.0).move(0.0, 12.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 8.0), Assembler.aabb(16.0, 8.0, 8.0).move(0.0, 0.0, 8.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 8.0, 8.0), Assembler.aabb(16.0, 8.0, 4.0).move(0.0, 8.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 8.0, 12.0), Assembler.aabb(16.0, 8.0, 4.0).move(0.0, 8.0, 12.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH));
    }

    public static void assembleInnerLeft(Assembler.CopycatRenderContext<?, ?> context, GlobalTransform transform) {
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(8.0, 4.0, 8.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.SOUTH | MutableCullFace.EAST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 4.0, 0.0), Assembler.aabb(8.0, 4.0, 8.0).move(0.0, 12.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH | MutableCullFace.EAST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 8.0), Assembler.aabb(16.0, 8.0, 8.0).move(0.0, 0.0, 8.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH));
        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 8.0, 8.0), Assembler.aabb(8.0, 8.0, 8.0).move(8.0, 8.0, 8.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.WEST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 8.0, 12.0), Assembler.aabb(8.0, 8.0, 4.0).move(0.0, 8.0, 12.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.EAST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 8.0, 8.0), Assembler.aabb(8.0, 8.0, 4.0).move(0.0, 8.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH | MutableCullFace.EAST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(12.0, 8.0, 0.0), Assembler.aabb(4.0, 8.0, 8.0).move(12.0, 8.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH | MutableCullFace.WEST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 8.0, 0.0), Assembler.aabb(4.0, 8.0, 8.0).move(0.0, 8.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH | MutableCullFace.EAST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 0.0, 0.0), Assembler.aabb(8.0, 8.0, 8.0).move(8.0, 0.0, 0.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.SOUTH | MutableCullFace.WEST));
    }

    public static void assembleOuterLeft(Assembler.CopycatRenderContext<?, ?> context, GlobalTransform transform) {
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 0.0, 0.0), Assembler.aabb(8.0, 4.0, 16.0).move(0.0, 0.0, 0.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.EAST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(0.0, 4.0, 0.0), Assembler.aabb(8.0, 4.0, 16.0).move(0.0, 12.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.EAST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 0.0, 0.0), Assembler.aabb(8.0, 4.0, 8.0).move(8.0, 0.0, 0.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.SOUTH | MutableCullFace.WEST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 4.0, 0.0), Assembler.aabb(8.0, 4.0, 8.0).move(8.0, 12.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH | MutableCullFace.WEST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 0.0, 8.0), Assembler.aabb(8.0, 8.0, 8.0).move(8.0, 0.0, 8.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH | MutableCullFace.WEST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(12.0, 8.0, 12.0), Assembler.aabb(4.0, 8.0, 4.0).move(12.0, 8.0, 12.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.WEST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 8.0, 12.0), Assembler.aabb(4.0, 8.0, 4.0).move(0.0, 8.0, 12.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.EAST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(12.0, 8.0, 8.0), Assembler.aabb(4.0, 8.0, 4.0).move(12.0, 8.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH | MutableCullFace.WEST));
        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 8.0, 8.0), Assembler.aabb(4.0, 8.0, 4.0).move(0.0, 8.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH | MutableCullFace.EAST));
    }
}

