/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.test_block;

import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.multistate.MultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.content.copycat.base.multistate.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.content.copycat.slab.CopycatSlabBlock;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatTestBlock
extends MultiStateCopycatBlock {
    public static final EnumProperty<SlabType> SLAB_TYPE = BlockStateProperties.f_61397_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;

    public CopycatTestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_(SLAB_TYPE, (Comparable)SlabType.BOTTOM));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{SLAB_TYPE}).m_61104_(new Property[]{AXIS}));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape shapeOverride = CopycatTestBlock.multiPlatformGetShape(state, level, pos, context);
        if (shapeOverride != null) {
            return shapeOverride;
        }
        return super.m_5940_(state, level, pos, context);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            return (BlockState)state.m_61124_(SLAB_TYPE, (Comparable)SlabType.DOUBLE);
        }
        Direction.Axis axis = context.m_7820_().m_122434_();
        boolean flag = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (context.m_43720_().f_82479_ - (double)blockPos.m_123341_() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (context.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> context.m_43720_().f_82481_ - (double)blockPos.m_123343_() > 0.5;
        };
        Direction clickedFace = context.m_43719_();
        return (BlockState)((BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)axis)).m_61124_(SLAB_TYPE, (Comparable)(clickedFace == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || clickedFace.m_122434_() != axis && !flag ? SlabType.BOTTOM : SlabType.TOP));
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        SlabType slabtype = (SlabType)pState.m_61143_(SLAB_TYPE);
        Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
        if (slabtype != SlabType.DOUBLE && itemstack.m_150930_(this.m_5456_())) {
            boolean flag = switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> {
                    if (pUseContext.m_43720_().f_82479_ - (double)pUseContext.m_8083_().m_123341_() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (pUseContext.m_43720_().f_82480_ - (double)pUseContext.m_8083_().m_123342_() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> pUseContext.m_43720_().f_82481_ - (double)pUseContext.m_8083_().m_123343_() > 0.5;
            };
            Direction direction = pUseContext.m_43719_();
            if (slabtype == SlabType.BOTTOM) {
                return direction == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || flag;
            }
            return direction == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE) || !flag;
        }
        return false;
    }

    @Override
    public int maxMaterials() {
        return 2;
    }

    @Override
    public Vec3i vectorScale(BlockState state) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3i(2, 1, 1);
            case Direction.Axis.Y -> new Vec3i(1, 2, 1);
            case Direction.Axis.Z -> new Vec3i(1, 1, 2);
        };
    }

    @Override
    public boolean partExists(BlockState state, String property) {
        SlabType slabType = (SlabType)state.m_61143_(SLAB_TYPE);
        if (property.equals(SlabType.BOTTOM.m_7912_())) {
            return slabType == SlabType.DOUBLE || slabType == SlabType.BOTTOM;
        }
        if (property.equals(SlabType.TOP.m_7912_())) {
            return slabType == SlabType.DOUBLE || slabType == SlabType.TOP;
        }
        return false;
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(SlabType.TOP.m_7912_(), SlabType.BOTTOM.m_7912_());
    }

    @Override
    public String getPropertyFromInteraction(BlockState state, BlockGetter level, Vec3i hitLocation, BlockPos blockPos, Direction facing, Vec3 unscaledHit) {
        if (hitLocation.m_123304_((Direction.Axis)state.m_61143_(AXIS)) > 0) {
            return SlabType.TOP.m_7912_();
        }
        return SlabType.BOTTOM.m_7912_();
    }

    @Override
    public Vec3i getVectorFromProperty(BlockState state, String property) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (property.equals(SlabType.TOP.m_7912_())) {
                    yield new Vec3i(1, 0, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Y -> {
                if (property.equals(SlabType.TOP.m_7912_())) {
                    yield new Vec3i(0, 1, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Z -> property.equals(SlabType.TOP.m_7912_()) ? new Vec3i(0, 0, 1) : new Vec3i(0, 0, 0);
        };
    }

    @Override
    public boolean isIgnoredConnectivitySide(String property, BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        BlockState toState = reader.m_8055_(toPos);
        if (reader instanceof ScaledBlockAndTintGetter) {
            ScaledBlockAndTintGetter scaledReader = (ScaledBlockAndTintGetter)reader;
            BlockPos fromTruePos = scaledReader.getTruePos(fromPos);
            BlockPos toTruePos = scaledReader.getTruePos(toPos);
            return fromTruePos.equals((Object)toTruePos);
        }
        return !toState.m_60713_((Block)this);
    }

    @Override
    public boolean canConnectTexturesToward(String property, BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (reader instanceof ScaledBlockAndTintGetter) {
            BlockPos toTruePos;
            ScaledBlockAndTintGetter scaledReader = (ScaledBlockAndTintGetter)reader;
            BlockPos fromTruePos = scaledReader.getTruePos(fromPos);
            return !fromTruePos.equals((Object)(toTruePos = scaledReader.getTruePos(toPos))) && toState.m_60713_((Block)this);
        }
        return toState.m_60713_((Block)this);
    }

    @Override
    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        state = super.m_6843_(state, rot);
        return CopycatSlabBlock.setApparentDirection(state, rot.m_55954_(CopycatSlabBlock.getApparentDirection(state)));
    }

    @Override
    public void rotate(@NotNull BlockState state, @NotNull MultiStateCopycatBlockEntity be, Rotation rotation) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (axis == Direction.Axis.Y) {
            return;
        }
        if (rotation == Rotation.CLOCKWISE_90 && axis == Direction.Axis.X || rotation == Rotation.CLOCKWISE_180 || rotation == Rotation.COUNTERCLOCKWISE_90 && axis == Direction.Axis.Z) {
            be.getMaterialItemStorage().remapStorage(s -> s.equals(Half.BOTTOM.m_7912_()) ? Half.TOP.m_7912_() : Half.BOTTOM.m_7912_());
        }
    }

    @Override
    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirrorIn) {
        state = super.m_6943_(state, mirrorIn);
        return state.m_60717_(mirrorIn.m_54846_(CopycatSlabBlock.getApparentDirection(state)));
    }

    @Override
    public void mirror(@NotNull BlockState state, @NotNull MultiStateCopycatBlockEntity be, Mirror mirror) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (axis == Direction.Axis.Y) {
            return;
        }
        if (mirror == Mirror.FRONT_BACK && axis == Direction.Axis.Z || mirror == Mirror.LEFT_RIGHT && axis == Direction.Axis.X) {
            be.getMaterialItemStorage().remapStorage(s -> s.equals(Half.BOTTOM.m_7912_()) ? Half.TOP.m_7912_() : Half.BOTTOM.m_7912_());
        }
    }
}

