/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.vertical_slice;

import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.content.copycat.MathHelper;
import com.copycatsplus.copycats.content.copycat.base.CTWaterloggedCopycatBlock;
import com.copycatsplus.copycats.content.copycat.base.IStateType;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatVerticalSliceBlock
extends CTWaterloggedCopycatBlock
implements ISpecialBlockItemRequirement,
IStateType {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    private static final VoxelShaper[] SHAPE_BY_LAYER = new VoxelShaper[]{CCShapes.EMPTY, CCShapes.SLICE_VERTICAL_2PX, CCShapes.SLICE_VERTICAL_4PX, CCShapes.SLICE_VERTICAL_6PX, CCShapes.SLICE_VERTICAL_8PX, CCShapes.SLICE_VERTICAL_10PX, CCShapes.SLICE_VERTICAL_12PX, CCShapes.SLICE_VERTICAL_14PX, CCShapes.SLICE_VERTICAL_16PX};
    private static final Map<Pair<Integer, Integer>, Direction> VERTICAL_POSITION_MAP = new HashMap<Pair<Integer, Integer>, Direction>();
    private static final Map<Pair<Direction, Integer>, Direction> HORIZONTAL_POSITION_MAP = new HashMap<Pair<Direction, Integer>, Direction>();

    public CopycatVerticalSliceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        BlockState toState = reader.m_8055_(toPos);
        if (toState.m_60713_((Block)this)) {
            return toState.m_61143_((Property)FACING) != direction || (Integer)toState.m_61143_((Property)LAYERS) != layers;
        }
        return true;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction face = MathHelper.DirectionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (face == null) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        if (toState.m_60713_((Block)this)) {
            try {
                return toState.m_61143_((Property)FACING) == facing && (Integer)toState.m_61143_((Property)LAYERS) == layers && face.m_122434_() == Direction.Axis.Y;
            }
            catch (IllegalStateException ignored) {
                return false;
            }
        }
        return false;
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return face.m_122434_() == Direction.Axis.Y || face == facing || face == facing.m_122428_();
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !this.canFaceBeOccluded(state, face);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        int zOffset;
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            if ((Integer)state.m_61143_((Property)LAYERS) < 8) {
                return (BlockState)state.m_61122_((Property)LAYERS);
            }
            Copycats.LOGGER.warn("Can't figure out where to place a slice! Please file an issue if you see this.");
            return state;
        }
        int xOffset = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_() > 0.5 ? 1 : -1;
        int n = zOffset = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_() > 0.5 ? 1 : -1;
        if (context.m_43719_().m_122434_() == Direction.Axis.Y) {
            return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)VERTICAL_POSITION_MAP.get(Pair.of((Object)xOffset, (Object)zOffset)));
        }
        return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)HORIZONTAL_POSITION_MAP.get(Pair.of((Object)context.m_43719_(), (Object)(context.m_43719_().m_122434_() == Direction.Axis.X ? zOffset : xOffset))));
    }

    public boolean m_6864_(@NotNull BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        if ((Integer)pState.m_61143_((Property)LAYERS) == 8) {
            return false;
        }
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        return pUseContext.m_43719_() == facing.m_122424_() || pUseContext.m_43719_() == facing.m_122427_();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if ((Integer)state.m_61143_((Property)LAYERS) <= 1) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (player != null && !player.m_7500_()) {
                List drops = Block.m_49874_((BlockState)((BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))), (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                for (ItemStack drop : drops) {
                    player.m_150109_().m_150079_(drop);
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LAYERS) - 1))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, new ItemStack((ItemLike)this.m_5456_(), ((Integer)state.m_61143_((Property)LAYERS)).intValue()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{FACING, LAYERS}));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)].get((Direction)pState.m_61143_((Property)FACING));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this) && CopycatVerticalSliceBlock.getMaterial((BlockGetter)level, (BlockPos)pos).m_60719_(CopycatVerticalSliceBlock.getMaterial((BlockGetter)level, (BlockPos)pos.m_121945_(dir)), dir.m_122424_())) {
            int layers = (Integer)state.m_61143_((Property)LAYERS);
            int neighborLayers = (Integer)neighborState.m_61143_((Property)LAYERS);
            if (layers == 8 && neighborLayers == 8) {
                return true;
            }
            return dir.m_122434_().m_122478_() && neighborState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && layers == neighborLayers;
        }
        return false;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        Direction.Axis mirrorAxis = null;
        for (Direction.Axis axis : Iterate.axes) {
            if (!pMirror.m_54842_().m_56526_(axis)) continue;
            mirrorAxis = axis;
            break;
        }
        if (mirrorAxis == null || mirrorAxis.m_122478_()) {
            return super.m_6943_(pState, pMirror);
        }
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        if (facing.m_122434_() != mirrorAxis) {
            return (BlockState)pState.m_61124_((Property)FACING, (Comparable)facing.m_122427_());
        }
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)facing.m_122428_());
    }

    static {
        for (Direction main : Iterate.horizontalDirections) {
            Direction cross = main.m_122428_();
            int mainOffset = main.m_122421_().m_122540_();
            int crossOffset = cross.m_122421_().m_122540_();
            if (main.m_122434_() == Direction.Axis.X) {
                VERTICAL_POSITION_MAP.put((Pair<Integer, Integer>)Pair.of((Object)mainOffset, (Object)crossOffset), main);
            } else {
                VERTICAL_POSITION_MAP.put((Pair<Integer, Integer>)Pair.of((Object)crossOffset, (Object)mainOffset), main);
            }
            HORIZONTAL_POSITION_MAP.put((Pair<Direction, Integer>)Pair.of((Object)main.m_122424_(), (Object)crossOffset), main);
            HORIZONTAL_POSITION_MAP.put((Pair<Direction, Integer>)Pair.of((Object)cross.m_122424_(), (Object)mainOffset), main);
        }
    }
}

