/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.wall;

import com.copycatsplus.copycats.content.copycat.base.model.SimpleCopycatPart;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.Assembler;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.GlobalTransform;
import com.copycatsplus.copycats.content.copycat.base.model.assembly.MutableCullFace;
import com.copycatsplus.copycats.content.copycat.wall.CopycatWallBlock;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;

public class CopycatWallModel
implements SimpleCopycatPart {
    @Override
    public void emitCopycatQuads(BlockState state, Assembler.CopycatRenderContext<?, ?> context, BlockState material) {
        boolean pole = (Boolean)state.m_61143_((Property)WallBlock.f_57949_);
        if (pole) {
            for (Direction direction : Iterate.horizontalDirections) {
                Assembler.assemblePiece(context, t -> t.rotateY((int)direction.m_122435_()), Assembler.vec3(4.0, 0.0, 4.0), Assembler.aabb(4.0, 16.0, 4.0), Assembler.cull(MutableCullFace.SOUTH | MutableCullFace.EAST));
            }
            block11: for (Direction direction : Iterate.horizontalDirections) {
                int rot = (int)direction.m_122435_();
                GlobalTransform transform = t -> t.rotateY(rot);
                switch ((WallSide)state.m_61143_(CopycatWallBlock.byDirection(direction))) {
                    case NONE: {
                        continue block11;
                    }
                    case LOW: {
                        Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 0.0, 12.0), Assembler.aabb(3.0, 7.0, 4.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH | MutableCullFace.EAST));
                        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 0.0, 12.0), Assembler.aabb(3.0, 7.0, 4.0).move(13.0, 0.0, 0.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.NORTH | MutableCullFace.WEST));
                        Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 7.0, 12.0), Assembler.aabb(3.0, 7.0, 4.0).move(0.0, 9.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.EAST));
                        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 7.0, 12.0), Assembler.aabb(3.0, 7.0, 4.0).move(13.0, 9.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.NORTH | MutableCullFace.WEST));
                        continue block11;
                    }
                    case TALL: {
                        Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 0.0, 12.0), Assembler.aabb(3.0, 16.0, 4.0), Assembler.cull(MutableCullFace.NORTH | MutableCullFace.EAST));
                        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 0.0, 12.0), Assembler.aabb(3.0, 16.0, 4.0).move(13.0, 0.0, 0.0), Assembler.cull(MutableCullFace.NORTH | MutableCullFace.WEST));
                    }
                }
            }
        } else {
            int rot;
            boolean tall = false;
            HashMap<Direction, WallSide> sides = new HashMap<Direction, WallSide>();
            for (Direction direction : Iterate.horizontalDirections) {
                WallSide wall = (WallSide)state.m_61143_(CopycatWallBlock.byDirection(direction));
                sides.put(direction, wall);
                if (wall != WallSide.TALL) continue;
                tall = true;
            }
            if (!(sides.get(Direction.SOUTH) != sides.get(Direction.NORTH) || sides.get(Direction.EAST) != sides.get(Direction.WEST) || sides.get(Direction.NORTH) != WallSide.NONE && sides.get(Direction.EAST) != WallSide.NONE || sides.get(Direction.NORTH) == WallSide.NONE && sides.get(Direction.EAST) == WallSide.NONE)) {
                int rot2 = sides.get(Direction.SOUTH) == WallSide.NONE ? 90 : 0;
                GlobalTransform transform = t -> t.rotateY(rot2);
                if (!tall) {
                    Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 0.0, 0.0), Assembler.aabb(3.0, 7.0, 16.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.EAST));
                    Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 0.0, 0.0), Assembler.aabb(3.0, 7.0, 16.0).move(13.0, 0.0, 0.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.WEST));
                    Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 7.0, 0.0), Assembler.aabb(3.0, 7.0, 16.0).move(0.0, 9.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.EAST));
                    Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 7.0, 0.0), Assembler.aabb(3.0, 7.0, 16.0).move(13.0, 9.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.WEST));
                } else {
                    Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 0.0, 0.0), Assembler.aabb(3.0, 16.0, 16.0).move(0.0, 0.0, 0.0), Assembler.cull(MutableCullFace.EAST));
                    Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 0.0, 0.0), Assembler.aabb(3.0, 16.0, 16.0).move(13.0, 0.0, 0.0), Assembler.cull(MutableCullFace.WEST));
                }
                return;
            }
            Direction extendSide = null;
            long sideCount = sides.values().stream().filter(s -> s != WallSide.NONE).count();
            if (sideCount == 1L) {
                extendSide = sides.entrySet().stream().filter(s -> s.getValue() != WallSide.NONE).findFirst().map(Map.Entry::getKey).orElse(null);
            } else {
                for (Direction direction : Iterate.horizontalDirections) {
                    boolean cullAdjacent;
                    boolean cullCurrent;
                    rot = (int)direction.m_122435_();
                    GlobalTransform transform = t -> t.rotateY(rot);
                    if (tall) {
                        cullCurrent = sides.get(direction.m_122424_()) == WallSide.TALL;
                        cullAdjacent = sides.get(direction.m_122427_()) == WallSide.TALL;
                        Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 0.0, 5.0), Assembler.aabb(3.0, 16.0, 3.0).move(0.0, 0.0, 0.0), Assembler.cull(MutableCullFace.SOUTH | MutableCullFace.EAST | (cullCurrent ? MutableCullFace.NORTH : 0) | (cullAdjacent ? MutableCullFace.WEST : 0)));
                        continue;
                    }
                    cullCurrent = sides.get(direction.m_122424_()) != WallSide.NONE;
                    cullAdjacent = sides.get(direction.m_122427_()) != WallSide.NONE;
                    Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 0.0, 5.0), Assembler.aabb(3.0, 7.0, 3.0).move(0.0, 0.0, 0.0), Assembler.cull(MutableCullFace.UP | MutableCullFace.SOUTH | MutableCullFace.EAST | (cullCurrent ? MutableCullFace.NORTH : 0) | (cullAdjacent ? MutableCullFace.WEST : 0)));
                    Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 7.0, 5.0), Assembler.aabb(3.0, 7.0, 3.0).move(0.0, 9.0, 0.0), Assembler.cull(MutableCullFace.DOWN | MutableCullFace.SOUTH | MutableCullFace.EAST | (cullCurrent ? MutableCullFace.NORTH : 0) | (cullAdjacent ? MutableCullFace.WEST : 0)));
                }
            }
            block14: for (Direction direction : Iterate.horizontalDirections) {
                rot = (int)direction.m_122435_();
                boolean extend = extendSide == direction;
                boolean cullEnd = !extend;
                GlobalTransform transform = t -> t.rotateY(rot);
                switch ((WallSide)sides.get(direction)) {
                    case NONE: {
                        continue block14;
                    }
                    case LOW: {
                        Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 0.0, extend ? 5.0 : 11.0), Assembler.aabb(3.0, 7.0, extend ? 11.0 : 5.0).move(0.0, 0.0, 0.0), Assembler.cull(MutableCullFace.UP | (cullEnd ? MutableCullFace.NORTH : 0) | MutableCullFace.EAST));
                        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 0.0, extend ? 5.0 : 11.0), Assembler.aabb(3.0, 7.0, extend ? 11.0 : 5.0).move(13.0, 0.0, 0.0), Assembler.cull(MutableCullFace.UP | (cullEnd ? MutableCullFace.NORTH : 0) | MutableCullFace.WEST));
                        Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 7.0, extend ? 5.0 : 11.0), Assembler.aabb(3.0, 7.0, extend ? 11.0 : 5.0).move(0.0, 9.0, 0.0), Assembler.cull(MutableCullFace.DOWN | (cullEnd ? MutableCullFace.NORTH : 0) | MutableCullFace.EAST));
                        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 7.0, extend ? 5.0 : 11.0), Assembler.aabb(3.0, 7.0, extend ? 11.0 : 5.0).move(13.0, 9.0, 0.0), Assembler.cull(MutableCullFace.DOWN | (cullEnd ? MutableCullFace.NORTH : 0) | MutableCullFace.WEST));
                        continue block14;
                    }
                    case TALL: {
                        Assembler.assemblePiece(context, transform, Assembler.vec3(5.0, 0.0, extend ? 5.0 : 11.0), Assembler.aabb(3.0, 16.0, extend ? 11.0 : 5.0).move(0.0, 0.0, 0.0), Assembler.cull((cullEnd ? MutableCullFace.NORTH : 0) | MutableCullFace.EAST));
                        Assembler.assemblePiece(context, transform, Assembler.vec3(8.0, 0.0, extend ? 5.0 : 11.0), Assembler.aabb(3.0, 16.0, extend ? 11.0 : 5.0).move(13.0, 0.0, 0.0), Assembler.cull((cullEnd ? MutableCullFace.NORTH : 0) | MutableCullFace.WEST));
                    }
                }
            }
        }
    }
}

