/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.enchantments.axe;

import com.jsburg.clash.enchantments.ClashEnchantment;
import com.jsburg.clash.registry.AllParticles;
import com.jsburg.clash.registry.MiscRegistry;
import com.jsburg.clash.weapons.util.AttackHelper;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ButcheryEnchantment
extends ClashEnchantment {
    public ButcheryEnchantment(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
    }

    public int m_6586_() {
        return 4;
    }

    public int m_6183_(int enchantmentLevel) {
        return 1 + (enchantmentLevel - 1) * 6;
    }

    public int m_6175_(int enchantmentLevel) {
        return this.m_6183_(enchantmentLevel) + 10;
    }

    public static float getDamageMultiplier(int level) {
        return 1.0f + 0.15f * (float)level;
    }

    public static int getPorkAmount(int level, RandomSource random) {
        int count = 0;
        for (int n = 1; n <= level; ++n) {
            if (!((double)random.m_188501_() <= 0.5)) continue;
            ++count;
        }
        return count;
    }

    public static boolean affectsEntity(LivingEntity target) {
        return target.m_6095_().m_204039_(MiscRegistry.PORKY);
    }

    protected boolean m_5975_(Enchantment enchantment) {
        if (enchantment instanceof DamageEnchantment) {
            return false;
        }
        return super.m_5975_(enchantment);
    }

    public static void onHit(int level, LivingEntity target) {
        if (!target.f_19853_.f_46443_) {
            RandomSource rand = target.f_19853_.m_213780_();
            AABB bb = target.m_20191_();
            double l = bb.m_82309_();
            Vec3 pos = new Vec3((rand.m_188500_() - 0.5) * l, rand.m_188500_() * l + 0.5, (rand.m_188500_() - 0.5) * l);
            AttackHelper.makeParticleServer((ServerLevel)target.f_19853_, (SimpleParticleType)AllParticles.BUTCHER_SPARK_EMITTER.get(), target.m_20182_().m_82549_(pos), Vec3.f_82478_, 0.0);
        }
    }
}

