/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.entity;

import com.google.common.collect.Lists;
import com.jsburg.clash.registry.AllParticles;
import com.jsburg.clash.registry.MiscRegistry;
import com.jsburg.clash.weapons.GreatbladeItem;
import com.jsburg.clash.weapons.util.AttackHelper;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GreatbladeSlashEntity
extends Entity {
    public int spriteFlip = 0;
    private UUID ownerUUID;
    private int ownerEntityId;
    private int timeLeft = 3;
    public float damage = 10.0f;
    public ItemStack swordStack = ItemStack.f_41583_;
    private final List<Entity> hitEntities = Lists.newLinkedList();
    private boolean isExecutioner = false;
    private int hasThrumParticle = 0;

    public GreatbladeSlashEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public GreatbladeSlashEntity(Level world, ItemStack sword, Vec3 pos, Entity owner, boolean executioner) {
        this(executioner ? (EntityType)MiscRegistry.GREATBLADE_SLASH_EXECUTIONER.get() : (EntityType)MiscRegistry.GREATBLADE_SLASH.get(), world);
        this.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        this.swordStack = sword;
        this.setOwner(owner);
        if (executioner) {
            this.damage += 5.0f;
            this.isExecutioner = true;
        }
    }

    public void applyThrum() {
        this.hasThrumParticle = 1;
    }

    public void applyWhirlwind(int level) {
        this.timeLeft += level;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setOwner(Entity owner) {
        if (owner != null) {
            this.ownerUUID = owner.m_20148_();
            this.ownerEntityId = owner.m_19879_();
        }
    }

    @Nullable
    public Entity getOwner() {
        if (this.ownerUUID != null && this.f_19853_ instanceof ServerLevel) {
            return ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID);
        }
        return this.ownerEntityId != 0 ? this.f_19853_.m_6815_(this.ownerEntityId) : null;
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        double speed = motion.m_82553_();
        Vec3 centerPos = this.m_20191_().m_82399_();
        double yOff = centerPos.m_7098_() - this.m_20186_();
        if (speed > 0.0) {
            double deceleration = 0.2;
            speed = Math.max(0.0, speed - deceleration);
            this.m_20256_(motion.m_82541_().m_82490_(speed));
            motion = this.m_20184_();
            Vec3 nextPos = this.m_20182_().m_82549_(motion);
            BlockHitResult raytrace = this.f_19853_.m_45547_(new ClipContext(centerPos, nextPos.m_82520_(0.0, yOff, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            if (raytrace.m_6662_() == HitResult.Type.MISS) {
                this.m_20219_(nextPos);
            } else {
                this.m_20219_(raytrace.m_82450_().m_82492_(0.0, yOff, 0.0));
            }
        }
        AttackHelper.makeParticleServer(this.f_19853_, AllParticles.GREATBLADE_SLASH, this.m_20191_().m_82399_().m_82549_(motion.m_82490_(0.5)), this.isExecutioner ? 1.0 : 0.0, this.hasThrumParticle, this.spriteFlip);
        Entity owner = this.getOwner();
        Function<LivingEntity, Boolean> enemyChecker = owner == null ? a -> true : livingentity -> !owner.m_7307_((Entity)livingentity);
        DamageSource damageSource = owner instanceof Player ? DamageSource.m_19344_((Player)((Player)owner)) : (owner == null ? DamageSource.m_19361_((Entity)this, null) : DamageSource.m_19370_((LivingEntity)((LivingEntity)owner)));
        for (LivingEntity livingentity2 : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_())) {
            if (livingentity2 == owner || !enemyChecker.apply(livingentity2).booleanValue() || this.hitEntities.contains(livingentity2) || livingentity2 instanceof ArmorStand && ((ArmorStand)livingentity2).m_31677_() || livingentity2 instanceof TamableAnimal && owner != null && ((TamableAnimal)livingentity2).m_21830_((LivingEntity)owner)) continue;
            this.hitEntities.add((Entity)livingentity2);
            if (this.f_19853_.f_46443_) continue;
            Vec3 diff = livingentity2.m_20182_().m_82546_(this.m_20182_()).m_82541_();
            livingentity2.m_147240_((double)0.4f, -diff.m_7096_(), -diff.m_7094_());
            float lastHealth = livingentity2.m_21223_();
            if (!livingentity2.m_6469_(damageSource, this.damage + AttackHelper.getBonusEnchantmentDamage(this.swordStack, (Entity)livingentity2))) continue;
            float healthDifference = lastHealth - livingentity2.m_21223_();
            if (this.f_19853_ instanceof ServerLevel && healthDifference > 2.0f) {
                int k = (int)((double)healthDifference * 0.5);
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, livingentity2.m_20185_(), livingentity2.m_20227_(0.5), livingentity2.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
            }
            if (!(this.swordStack.m_41720_() instanceof GreatbladeItem)) continue;
            ((GreatbladeItem)this.swordStack.m_41720_()).onSlashHit(this.swordStack, livingentity2, owner);
        }
        --this.timeLeft;
        if (this.timeLeft == 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.hitEntities.clear();
        }
    }

    protected void m_8097_() {
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.m_128362_("Owner", this.ownerUUID);
        }
        compound.m_128350_("Damage", this.damage);
        compound.m_128405_("TimeLeft", this.timeLeft);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.ownerUUID = compound.m_128342_("Owner");
        }
        this.damage = compound.m_128457_("Damage");
        this.timeLeft = compound.m_128451_("TimeLeft");
    }

    public Packet<?> m_5654_() {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }
}

