/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.event;

import com.jsburg.clash.registry.AllParticles;
import com.jsburg.clash.util.Easing;
import com.jsburg.clash.util.ItemAnimator;
import com.jsburg.clash.util.ScreenShaker;
import com.jsburg.clash.weapons.GreatbladeItem;
import com.jsburg.clash.weapons.SweptAxeItem;
import com.jsburg.clash.weapons.util.ISpearAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="clash", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    private static boolean needsPop = false;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        AllParticles.registerParticleFactories();
    }

    public static void doClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ScreenShaker.tick();
            ItemAnimator.tick();
        }
    }

    public static void doCameraStuff(ViewportEvent.ComputeCameraAngles event) {
        ScreenShaker.applyScreenShake(event.getPartialTick(), event);
        needsPop = false;
    }

    public static void fiddleWithHands(RenderHandEvent event) {
        boolean greatbladeDraw;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (needsPop) {
            event.getPoseStack().m_85849_();
            needsPop = false;
        }
        boolean leftHanded = player.m_5737_() == HumanoidArm.LEFT ^ event.getHand() == InteractionHand.OFF_HAND;
        ItemAnimator.ItemAnimation animation = ItemAnimator.getAnimation(GreatbladeItem.GreatbladeAnimation.class, (Player)player, player.m_7655_());
        float animationProgress = 0.0f;
        if (animation != null) {
            animationProgress = animation.getProgress(event.getPartialTick());
        }
        boolean sweptAxeDraw = event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().m_41720_() instanceof SweptAxeItem && (double)event.getEquipProgress() > 0.1;
        boolean bl = greatbladeDraw = event.getItemStack().m_41720_() instanceof GreatbladeItem && (event.getHand() == player.m_7655_() && player.m_6117_() || animation != null);
        if (event.getItemStack().m_41720_() instanceof ISpearAnimation) {
            int sideFlip;
            boolean goingToMove;
            boolean isActive = event.getHand() == player.m_7655_() && player.m_6117_();
            float cooldown = player.m_36335_().m_41521_(event.getItemStack().m_41720_(), event.getPartialTick());
            boolean isCoolingDown = cooldown > 0.0f && !isActive && !player.f_20911_;
            boolean bl2 = goingToMove = isActive || isCoolingDown;
            if (goingToMove && event.getHand() == InteractionHand.MAIN_HAND) {
                event.getPoseStack().m_85836_();
                needsPop = true;
            }
            int n = sideFlip = leftHanded ? -1 : 1;
            if (isActive) {
                Item spear = event.getItemStack().m_41720_();
                ISpearAnimation chargeGetter = (ISpearAnimation)spear;
                int useCount = player.m_21212_();
                int useDuration = spear.m_8105_(event.getItemStack());
                int useTime = useDuration - useCount;
                float chargePercent = Math.min(((float)useTime + event.getPartialTick()) / (float)chargeGetter.getMaxCharge(event.getItemStack()), 1.0f);
                float xAngle = -6.0f * chargePercent;
                float yAngle = 0.0f * chargePercent;
                float zAngle = 20.0f * chargePercent * (float)sideFlip;
                event.getPoseStack().m_85845_(new Quaternion(xAngle, yAngle, zAngle, true));
                double chargeOver = ((float)useTime + event.getPartialTick() - (float)(chargeGetter.getMaxCharge(event.getItemStack()) - 4)) / 4.0f;
                chargeOver = Math.pow(Math.max(0.0, Math.min(1.0, chargeOver)), 2.0);
                if (chargeOver > 0.0) {
                    double n2 = Math.sin((double)((float)player.f_19797_ + event.getPartialTick()) * 1.3) * 0.005 * (double)chargePercent;
                    event.getPoseStack().m_85837_(0.0, n2, 0.0);
                    event.getPoseStack().m_85837_(0.0, 0.0, 0.1 * chargeOver);
                }
            }
            if (isCoolingDown) {
                PoseStack stack = event.getPoseStack();
                float cd = (float)Math.pow(cooldown, 3.0);
                stack.m_85845_(new Quaternion(-10.0f * cd, 4.0f * cd, 0.0f, true));
                stack.m_85837_(0.0, -0.1 * (double)cd, -0.1 * (double)cd);
            }
        }
        if (sweptAxeDraw || greatbladeDraw) {
            float swingProgress = event.getSwingProgress();
            HumanoidArm side = player.m_5737_();
            PoseStack stack = event.getPoseStack();
            int sideFlip = leftHanded ? -1 : 1;
            ItemInHandRenderer renderer = Minecraft.m_91087_().m_91290_().m_234586_();
            ItemTransforms.TransformType transform = leftHanded ? ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND : ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
            float pi = (float)Math.PI;
            stack.m_85836_();
            if (sweptAxeDraw) {
                float xOffset = -1.4f * Mth.m_14031_((float)(swingProgress * pi));
                float yOffset = 0.2f * Mth.m_14031_((float)((float)(Math.sqrt(swingProgress) * (double)pi * 2.0)));
                float zOffset = -0.6f * Mth.m_14031_((float)(swingProgress * pi * 2.0f));
                stack.m_85837_((double)((float)sideFlip * xOffset), (double)yOffset, (double)zOffset);
                ClientEvents.transformSideFirstPerson(stack, side, swingProgress == 0.0f || (double)swingProgress > 0.7 || event.getEquipProgress() == 0.0f ? event.getEquipProgress() : 0.0f);
                stack.m_85845_(Vector3f.f_122227_.m_122240_((float)(sideFlip * -80) * Mth.m_14031_((float)((float)(Math.sqrt(swingProgress) * (double)pi)))));
                stack.m_85845_(Vector3f.f_122223_.m_122240_(-180.0f * Mth.m_14031_((float)(swingProgress * pi))));
            }
            if (greatbladeDraw) {
                float swingPercent;
                GreatbladeItem sword = (GreatbladeItem)event.getItemStack().m_41720_();
                int useCount = player.m_21212_();
                int useDuration = sword.m_8105_(event.getItemStack());
                int useTime = useDuration - useCount;
                float chargePercent = Math.min(((float)useTime + event.getPartialTick()) / (float)(sword.getMaxCharge() + 1), 1.0f);
                if ((double)chargePercent > 0.8) {
                    double n = Math.sin((double)((float)player.f_19797_ + event.getPartialTick()) * 1.3) * 0.005 * (double)chargePercent;
                    stack.m_85837_(0.0, n, 0.0);
                }
                if ((swingPercent = animationProgress) > 0.0f) {
                    chargePercent = 1.0f;
                } else {
                    swingPercent = 0.0f;
                }
                float chargeLerp = Mth.m_14031_((float)((float)(Math.pow(chargePercent, 3.0) * (double)pi / 2.0))) - swingPercent;
                float swingEase = Easing.combine(Easing.Quart.out(swingPercent), swingPercent, 0.55f);
                float sineEase = Mth.m_14031_((float)(swingEase * pi));
                float fullSineEase = Mth.m_14031_((float)(swingEase * 2.0f * pi));
                boolean executioner = GreatbladeItem.hasExecutioner(event.getItemStack());
                stack.m_85837_((double)((float)(1 * sideFlip) * chargeLerp * (executioner ? 0.8f : 1.0f)), -1.2 * (double)chargeLerp * (double)(executioner ? 0.65f : 1.0f), -0.2 * (double)chargeLerp);
                stack.m_85837_((double)(-2.0f * swingEase * (float)sideFlip * (executioner ? 0.5f : 1.0f)), 0.15 * (double)sineEase - 0.1 * (double)swingEase, (double)(0.0f * sineEase));
                stack.m_85845_(Vector3f.f_122225_.m_122240_(-10.0f * chargeLerp * (float)sideFlip));
                stack.m_85845_(Vector3f.f_122227_.m_122240_(140.0f * chargeLerp * (float)sideFlip * (executioner ? 1.15f : 1.0f)));
                ClientEvents.transformSideFirstPerson(stack, leftHanded ? HumanoidArm.LEFT : HumanoidArm.RIGHT, 0.0f);
                Vector3f axis = new Vector3f(0.0f, 0.0f, 1.0f);
                stack.m_85845_(axis.m_122240_(90.0f * swingEase * (float)sideFlip * (executioner ? 1.4f : 1.0f)));
                stack.m_85845_(Vector3f.f_122223_.m_122240_(210.0f * swingEase));
                stack.m_85837_(0.2 * (double)sineEase * (double)sideFlip, -1.2 * (double)swingEase, 0.0);
            }
            renderer.m_109322_((LivingEntity)player, event.getItemStack(), transform, leftHanded, stack, event.getMultiBufferSource(), event.getPackedLight());
            stack.m_85849_();
            event.setCanceled(true);
        }
    }

    private static void transformFirstPerson(PoseStack matrixStackIn, HumanoidArm handIn, float swingProgress) {
        int i = handIn == HumanoidArm.RIGHT ? 1 : -1;
        float f = Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI));
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)i * (45.0f + f * -20.0f)));
        float f1 = Mth.m_14031_((float)((float)(Math.sqrt(swingProgress) * 3.1415927410125732)));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)i * f1 * -20.0f));
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(f1 * -80.0f));
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)i * -45.0f));
    }

    private static void transformSideFirstPerson(PoseStack matrixStackIn, HumanoidArm handIn, float equippedProg) {
        int i = handIn == HumanoidArm.RIGHT ? 1 : -1;
        matrixStackIn.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + equippedProg * -0.6f), (double)-0.72f);
    }
}

