/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.event;

import com.jsburg.clash.enchantments.axe.ButcheryEnchantment;
import com.jsburg.clash.enchantments.axe.RampageEnchantment;
import com.jsburg.clash.enchantments.axe.RetaliationEnchantment;
import com.jsburg.clash.registry.AllEffects;
import com.jsburg.clash.registry.AllEnchantments;
import com.jsburg.clash.registry.AllItems;
import com.jsburg.clash.registry.AllParticles;
import com.jsburg.clash.weapons.util.AttackHelper;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="clash", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LivingEvents {
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.isRecentlyHit() && LivingEvents.wasMeleeCaused(event.getSource())) {
            RandomSource random;
            int porkCount;
            LivingEntity source = (LivingEntity)event.getSource().m_7639_();
            LivingEntity target = event.getEntity();
            ItemStack weapon = source.m_21205_();
            int butcherLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.BUTCHERY.get()), (ItemStack)weapon);
            if (butcherLevel > 0 && ButcheryEnchantment.affectsEntity(target) && weapon.m_41720_() != AllItems.SWEPT_AXE_HEAD.get() && (porkCount = ButcheryEnchantment.getPorkAmount(butcherLevel, random = target.m_20193_().m_213780_())) > 0) {
                ItemEntity porkDrop = new ItemEntity(target.m_20193_(), target.m_20185_() + random.m_188500_() - 0.5, target.m_20186_() + random.m_188500_() + 0.5, target.m_20189_() + random.m_188500_() - 0.5, new ItemStack((ItemLike)Items.f_42485_, porkCount));
                if (!target.m_20193_().f_46443_) {
                    Vec3 pos = AttackHelper.getEntityPosition((Entity)porkDrop);
                    AttackHelper.makeParticleServer((ServerLevel)target.m_20193_(), (SimpleParticleType)AllParticles.BONUS_DROP.get(), pos, Vec3.f_82478_, 0.0);
                }
                event.getDrops().add(porkDrop);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        LivingEntity target;
        if (LivingEvents.wasMeleeCaused(event.getSource())) {
            LivingEntity source = (LivingEntity)event.getSource().m_7639_();
            target = event.getEntity();
            ItemStack weapon = source.m_21205_();
            int butcherLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.BUTCHERY.get()), (ItemStack)weapon);
            if (butcherLevel > 0 && ButcheryEnchantment.affectsEntity(target) && weapon.m_41720_() != AllItems.SWEPT_AXE_HEAD.get()) {
                event.setAmount(event.getAmount() * ButcheryEnchantment.getDamageMultiplier(butcherLevel));
                ButcheryEnchantment.onHit(butcherLevel, target);
            }
        }
        if ((target = event.getEntity()) instanceof Player) {
            Player hurtPlayer = (Player)target;
            ItemStack heldItem = hurtPlayer.m_21205_();
            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.RETALIATION.get()), (ItemStack)heldItem) > 0) {
                RetaliationEnchantment.onUserHurt((LivingEntity)hurtPlayer, EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.RETALIATION.get()), (ItemStack)heldItem));
            }
        }
        if (event.getEntity().m_21124_((MobEffect)AllEffects.STAGGERED.get()) != null) {
            event.getEntity().m_21195_((MobEffect)AllEffects.STAGGERED.get());
        }
    }

    @SubscribeEvent
    public static void onEntityKill(LivingDeathEvent event) {
        if (LivingEvents.wasMeleeCaused(event.getSource())) {
            LivingEntity source = (LivingEntity)event.getSource().m_7639_();
            LivingEntity target = event.getEntity();
            ItemStack weapon = source.m_21205_();
            int rampageLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.RAMPAGE.get()), (ItemStack)weapon);
            if (rampageLevel > 0) {
                RampageEnchantment.onKill(source, rampageLevel);
            }
        }
    }

    private static boolean wasMeleeCaused(DamageSource source) {
        return source.m_7639_() instanceof LivingEntity && LivingEvents.isMeleeDamage(source);
    }

    private static boolean isMeleeDamage(DamageSource source) {
        return source.m_7640_() == source.m_7639_();
    }
}

