/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.mixin;

import com.google.common.collect.ImmutableSet;
import com.jsburg.clash.weapons.util.IThirdPersonArmController;
import java.util.Set;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin {
    private static final Set<InteractionHand> hands = ImmutableSet.of((Object)InteractionHand.MAIN_HAND, (Object)InteractionHand.OFF_HAND);

    @Inject(method={"setupAttackAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends LivingEntity> void onArmSwing(T entity, float ageInTicks, CallbackInfo ci) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (InteractionHand hand : hands) {
                IThirdPersonArmController.AnimType type;
                boolean active;
                boolean bl = active = player.m_6117_() && hand == player.m_7655_();
                ItemStack handItem = player.m_21120_(hand);
                Item item = handItem.m_41720_();
                if (!(item instanceof IThirdPersonArmController) || (type = ((IThirdPersonArmController)item).hasThirdPersonAnim(player, handItem, active, hand)) == IThirdPersonArmController.AnimType.FALSE) continue;
                boolean leftHanded = hand == InteractionHand.OFF_HAND ^ player.m_5737_() == HumanoidArm.LEFT;
                float partialTicks = ageInTicks % 1.0f;
                ((IThirdPersonArmController)item).doThirdPersonAnim(player, (HumanoidModel)this, handItem, partialTicks, leftHanded, active, hand);
                if (type != IThirdPersonArmController.AnimType.OVERWRITES) break;
                ci.cancel();
                break;
            }
        }
    }
}

