/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DashDustParticle
extends TextureSheetParticle {
    private final int spinDir;
    private int growTime;

    protected DashDustParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet sprite) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.m_108335_(sprite);
        this.setMotion(motionX, motionY, motionZ);
        this.f_107204_ = this.f_107231_ = (float)((double)(this.f_107223_.m_188501_() * 2.0f) * Math.PI);
        this.spinDir = (int)(((double)this.f_107223_.m_188503_(1) - 0.5) * 2.0);
        this.f_107225_ = 10 + this.f_107223_.m_188503_(4);
        this.growTime = this.f_107223_.m_188503_(2) + 1;
        this.f_107663_ = 0.4f + this.f_107223_.m_188501_() * 0.3f;
    }

    private void setMotion(double X, double Y, double Z) {
        this.f_107215_ = X;
        this.f_107216_ = Y;
        this.f_107217_ = Z;
    }

    private void scaleMotion(double n) {
        this.setMotion(this.f_107215_ * n, this.f_107216_ * n, this.f_107217_ * n);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.growTime <= 0) {
            this.f_107663_ *= 0.8f;
        } else {
            --this.growTime;
            this.f_107663_ = (float)((double)this.f_107663_ * 1.1);
        }
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += 0.1f * (float)this.spinDir * (1.0f / this.f_107663_);
        this.scaleMotion(0.9 - (double)(this.f_107663_ / 10.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DashDustParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
        }
    }
}

