/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.particle;

import com.jsburg.clash.util.ScreenShaker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ScreenShakerParticle
extends NoRenderParticle {
    private final double shakeIntensity;
    private final double shakeTime;
    private final double falloffDistance;

    protected ScreenShakerParticle(ClientLevel world, double x, double y, double z, double shakeIntensity, double shakeTime, double fallOffDistance) {
        super(world, x, y, z);
        this.shakeIntensity = shakeIntensity;
        this.shakeTime = shakeTime;
        this.falloffDistance = fallOffDistance;
    }

    public void m_5989_() {
        this.m_107274_();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Vec3 diff = player.m_20182_().m_82492_(this.f_107209_, this.f_107210_, this.f_107211_);
        double intensityScale = Math.pow(1.0 - Mth.m_14008_((double)(diff.m_82553_() / this.falloffDistance), (double)0.0, (double)1.0), 2.0);
        if (intensityScale > 0.0) {
            ScreenShaker.setScreenShake((int)this.shakeTime, this.shakeIntensity * intensityScale);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprite) {
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double shakeIntensity, double shakeTime, double fallOffDistance) {
            return new ScreenShakerParticle(worldIn, x, y, z, shakeIntensity, shakeTime, fallOffDistance);
        }
    }
}

