/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpearStabParticle
extends TextureSheetParticle {
    private final SpriteSet spriteWithAge;
    private static final Vec3 UP = new Vec3(0.0, 1.0, 0.0);

    protected SpearStabParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteWithAge) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        float f;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.spriteWithAge = spriteWithAge;
        this.f_107225_ = 5;
        this.f_107227_ = f = this.f_107223_.m_188501_() * 0.2f + 0.8f;
        this.f_107228_ = f;
        this.f_107229_ = f;
        this.f_107663_ = 0.8f;
        this.m_108339_(spriteWithAge);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    public int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.spriteWithAge);
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= (double)0.8f;
            this.f_107216_ *= (double)0.8f;
            this.f_107217_ *= (double)0.8f;
            this.f_107663_ *= 0.9f;
            if (this.f_107218_) {
                this.f_107215_ *= (double)0.7f;
                this.f_107217_ *= (double)0.7f;
            }
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 viewAngle = new Vec3(renderInfo.m_90596_());
        if (viewAngle.m_7098_() != 1.0) {
            Vec3 motion = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82541_();
            Vec3 particlePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
            Vec3 viewPos = renderInfo.m_90583_();
            Vec3 relativePos = particlePos.m_82546_(viewPos).m_82541_();
            Vec3 particleInView = relativePos.m_82537_(motion).m_82537_(viewAngle);
            Vec3 xPlane = viewAngle.m_82537_(UP);
            Vec3 yPlane = viewAngle.m_82537_(xPlane);
            double xValue = particleInView.m_82526_(xPlane);
            double yValue = particleInView.m_82526_(yPlane);
            this.f_107204_ = this.f_107231_ = (float)(Math.atan2(yValue, xValue) + 1.5707963267948966);
        }
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SpearStabParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

