/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.registry;

import com.jsburg.clash.particle.AxeSweepParticle;
import com.jsburg.clash.particle.ButcherSparkEmitter;
import com.jsburg.clash.particle.ClashSpriteParticle;
import com.jsburg.clash.particle.DashDustParticle;
import com.jsburg.clash.particle.ScreenShakerParticle;
import com.jsburg.clash.particle.SpearCritParticle;
import com.jsburg.clash.particle.SpearStabParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AllParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"clash");
    public static final RegistryObject<SimpleParticleType> SPEAR_STAB = AllParticles.register("spear_stab");
    public static final RegistryObject<SimpleParticleType> SPEAR_CRIT = AllParticles.register("spear_crit");
    public static final RegistryObject<SimpleParticleType> DASH_DUST = AllParticles.register("dash_dust", false);
    public static final RegistryObject<SimpleParticleType> AXE_SWEEP = AllParticles.register("axe_sweep");
    public static final RegistryObject<SimpleParticleType> BUTCHER_SPARK = AllParticles.register("butcher_spark", false);
    public static final RegistryObject<SimpleParticleType> BUTCHER_SPARK_EMITTER = AllParticles.register("butcher_spark_emitter");
    public static final RegistryObject<SimpleParticleType> BONUS_DROP = AllParticles.register("bonus_drop");
    public static final RegistryObject<SimpleParticleType> SCREEN_SHAKER = AllParticles.register("screen_shaker");
    public static final RegistryObject<SimpleParticleType> SAILING_TRAIL = AllParticles.register("sailing_trail");
    public static final RegistryObject<SimpleParticleType> GREATBLADE_SLASH = AllParticles.register("greatblade_slash_2");

    public static void registerParticleFactories() {
        ParticleEngine manager = Minecraft.m_91087_().f_91061_;
        manager.m_107378_((ParticleType)SPEAR_STAB.get(), SpearStabParticle.Factory::new);
        manager.m_107378_((ParticleType)SPEAR_CRIT.get(), SpearCritParticle.Factory::new);
        manager.m_107378_((ParticleType)DASH_DUST.get(), DashDustParticle.Factory::new);
        manager.m_107378_((ParticleType)AXE_SWEEP.get(), AxeSweepParticle.Factory::new);
        manager.m_107378_((ParticleType)BUTCHER_SPARK.get(), ClashSpriteParticle::ButcherSpark);
        manager.m_107378_((ParticleType)BUTCHER_SPARK_EMITTER.get(), ButcherSparkEmitter.Factory::new);
        manager.m_107378_((ParticleType)BONUS_DROP.get(), ClashSpriteParticle::BonusDrop);
        manager.m_107378_((ParticleType)SCREEN_SHAKER.get(), ScreenShakerParticle.Factory::new);
        manager.m_107378_((ParticleType)SAILING_TRAIL.get(), ClashSpriteParticle::SailingTrail);
        manager.m_107378_((ParticleType)GREATBLADE_SLASH.get(), AxeSweepParticle.BladeFactory::new);
    }

    private static RegistryObject<SimpleParticleType> register(String name) {
        return AllParticles.register(name, true);
    }

    private static RegistryObject<SimpleParticleType> register(String name, boolean alwaysShow) {
        return PARTICLE_TYPES.register(name, () -> new SimpleParticleType(alwaysShow));
    }
}

