/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.util;

import java.util.function.Function;

public class Easing {
    public static Ease Quart = new Ease(){

        @Override
        public float in(float x) {
            return x * x * x * x;
        }

        @Override
        public float out(float x) {
            return 1.0f - Easing.pow(1.0f - x, 4.0f);
        }

        @Override
        public float inOut(float x) {
            return (double)x < 0.5 ? 8.0f * x * x * x * x : 1.0f - Easing.pow(-2.0f * x + 2.0f, 4.0f) / 2.0f;
        }
    };
    public static Ease Circ = new Ease(){

        @Override
        public float in(float x) {
            return 1.0f - Easing.sqrt(1.0f - Easing.pow(x, 2.0f));
        }

        @Override
        public float out(float x) {
            return Easing.sqrt(1.0f - Easing.pow(x - 1.0f, 2.0f));
        }

        @Override
        public float inOut(float x) {
            return (double)x < 0.5 ? (1.0f - Easing.sqrt(1.0f - Easing.pow(2.0f * x, 2.0f))) / 2.0f : (Easing.sqrt(1.0f - Easing.pow(-2.0f * x + 2.0f, 2.0f)) + 1.0f) / 2.0f;
        }
    };
    public static Ease Back = new Ease(){
        private static final float c1 = 1.70158f;
        private static final float c2 = 2.5949094f;
        private static final float c3 = 2.70158f;

        @Override
        public float in(float x) {
            return 2.70158f * x * x * x - 1.70158f * x * x;
        }

        @Override
        public float out(float x) {
            return 1.0f + 2.70158f * Easing.pow(x - 1.0f, 3.0f) + 1.70158f * Easing.pow(x - 1.0f, 2.0f);
        }

        @Override
        public float inOut(float x) {
            return (double)x < 0.5 ? Easing.pow(2.0f * x, 2.0f) * (7.189819f * x - 2.5949094f) / 2.0f : (Easing.pow(2.0f * x - 2.0f, 2.0f) * (3.5949094f * (x * 2.0f - 2.0f) + 2.5949094f) + 2.0f) / 2.0f;
        }
    };

    public static float combine(Function<Float, Float> a, Function<Float, Float> b, float t, float blendRatio) {
        return Easing.combine(a.apply(Float.valueOf(t)).floatValue(), b.apply(Float.valueOf(t)).floatValue(), blendRatio);
    }

    public static float combine(float a, float b, float blendRatio) {
        return a * blendRatio + b * (1.0f - blendRatio);
    }

    private static float pow(float a, float b) {
        return (float)Math.pow(a, b);
    }

    private static float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public static abstract class Ease {
        public abstract float in(float var1);

        public abstract float out(float var1);

        public abstract float inOut(float var1);
    }
}

