/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemAnimator {
    private static final List<AnimationHolder> animationList = new LinkedList<AnimationHolder>();

    public static void tick() {
        if (animationList.isEmpty()) {
            return;
        }
        ArrayList toRemove = new ArrayList();
        animationList.forEach(animationHolder -> {
            boolean doRemove;
            if (animationHolder.isValid()) {
                ItemAnimation animation = animationHolder.animation;
                animation.tick();
                doRemove = animation.isComplete();
            } else {
                doRemove = true;
            }
            if (doRemove) {
                toRemove.add(animationHolder);
            }
        });
        toRemove.forEach(animationList::remove);
    }

    public static void startAnimation(Player player, ItemStack item, InteractionHand hand, ItemAnimation animation) {
        animationList.add(new AnimationHolder(player, animation, item, hand));
    }

    @CheckForNull
    public static <T extends ItemAnimation> ItemAnimation getAnimation(Class<T> animationType, Player player, InteractionHand hand) {
        for (AnimationHolder holder : animationList) {
            ItemAnimation animation = holder.animation;
            if (!animationType.isInstance(animation) || holder.boundEntity != player || holder.heldHand != hand) continue;
            return animation;
        }
        return null;
    }

    private static class AnimationHolder {
        public final Player boundEntity;
        public final ItemAnimation animation;
        public final ItemStack boundItem;
        public final InteractionHand heldHand;

        public AnimationHolder(Player target, ItemAnimation animation, ItemStack item, InteractionHand itemHand) {
            this.boundEntity = target;
            this.animation = animation;
            this.boundItem = item;
            this.heldHand = itemHand;
        }

        public boolean isValid() {
            boolean isAlive = this.boundEntity.m_6084_();
            boolean stackCheck = ItemStack.m_41746_((ItemStack)this.boundEntity.m_21120_(this.heldHand), (ItemStack)this.boundItem);
            return isAlive && stackCheck;
        }
    }

    public static abstract class ItemAnimation {
        int lifetime;
        int lifetimeMax;

        protected abstract void tick();

        public abstract float getProgress();

        public abstract float getProgress(float var1);

        protected boolean isComplete() {
            return this.lifetime > this.lifetimeMax;
        }
    }

    public static class SimpleItemAnimation
    extends ItemAnimation {
        public SimpleItemAnimation(int duration) {
            this.lifetime = 0;
            this.lifetimeMax = duration;
        }

        @Override
        protected void tick() {
            ++this.lifetime;
        }

        @Override
        public float getProgress() {
            return (float)this.lifetime / (float)this.lifetimeMax;
        }

        @Override
        public float getProgress(float partialTicks) {
            return Math.min(((float)this.lifetime + partialTicks) / (float)this.lifetimeMax, 1.0f);
        }
    }
}

