/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.util;

import com.jsburg.clash.registry.Config;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.ViewportEvent;

public class ScreenShaker {
    private static final Random RANDOM = new Random();
    private static double ShakeX = 0.0;
    private static double ShakeY = 0.0;
    private static double LastX = 0.0;
    private static double LastY = 0.0;
    private static int ShakeTime = 0;
    private static double Intensity = 0.0;
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void tick() {
        if (ShakeTime >= 1) {
            --ShakeTime;
            LastX = ShakeX;
            LastY = ShakeY;
            ShakeX = ScreenShaker.uRandom(0.2) * Intensity;
            ShakeY = ScreenShaker.uRandom(0.4) * Intensity;
            Intensity *= 0.8;
        } else {
            ShakeX = 0.0;
            ShakeY = 0.0;
        }
    }

    private static double uRandom(double n) {
        double flip = ((double)RANDOM.nextInt(2) - 0.5) * 2.0;
        return (1.0 - Math.pow(RANDOM.nextDouble(), 2.0)) * n * flip;
    }

    public static void setScreenShake(int time, double intensity) {
        if ((Double)Config.SCREENSHAKE_MULTIPLIER.get() <= 0.0) {
            return;
        }
        ShakeTime = time;
        Intensity = intensity;
    }

    public static void setScreenShake(int time) {
        ScreenShaker.setScreenShake(time, 0.8);
    }

    public static void applyScreenShake(double partialTicks, ViewportEvent.ComputeCameraAngles event) {
        if (ShakeTime > 0) {
            double strength = (Double)Config.SCREENSHAKE_MULTIPLIER.get();
            double lerp = partialTicks;
            double x = LastX + (ShakeX - LastX) * lerp;
            double y = LastY + (ShakeY - LastY) * lerp;
            event.setPitch((float)(((double)event.getPitch() + y * 5.0) * strength));
            event.setRoll((float)(((double)event.getRoll() + x * 5.0) * strength));
        }
    }
}

