/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.weapons;

import com.jsburg.clash.entity.GreatbladeSlashEntity;
import com.jsburg.clash.registry.AllEffects;
import com.jsburg.clash.registry.AllEnchantments;
import com.jsburg.clash.registry.AllParticles;
import com.jsburg.clash.util.ItemAnimator;
import com.jsburg.clash.util.MiscHelper;
import com.jsburg.clash.util.TextHelper;
import com.jsburg.clash.weapons.util.AttackHelper;
import com.jsburg.clash.weapons.util.IActiveResetListener;
import com.jsburg.clash.weapons.util.IHitListener;
import com.jsburg.clash.weapons.util.IThirdPersonArmController;
import com.jsburg.clash.weapons.util.IThirdPersonRenderHook;
import com.jsburg.clash.weapons.util.WeaponItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GreatbladeItem
extends WeaponItem
implements IThirdPersonArmController,
IThirdPersonRenderHook,
IHitListener,
IActiveResetListener {
    private final float baseDamage;
    private static final String THRUM_KEY = "has_thrum";

    public GreatbladeItem(float attackDamage, float attackSpeed, Item.Properties properties) {
        super(attackDamage, attackSpeed, properties);
        this.baseDamage = attackDamage;
    }

    public float getSlashDamage(ItemStack stack) {
        float base;
        float f = base = GreatbladeItem.hasExecutioner(stack) ? 10.0f : 5.0f;
        if (GreatbladeItem.hasThrum(stack)) {
            base += (float)(2 * GreatbladeItem.thrumLevel(stack));
        }
        return base;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"item.clash.spear.when_charged").m_130940_(ChatFormatting.GRAY));
        tooltip.add(TextHelper.getBonusText("item.clash.greatblade.bonus_damage", this.getSlashDamage(stack)));
    }

    private static boolean hasSailing(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.SAILING.get()), (ItemStack)stack) > 0;
    }

    private static int crushingLevel(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.CRUSHING.get()), (ItemStack)stack);
    }

    public static boolean hasExecutioner(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.EXECUTIONER.get()), (ItemStack)stack) > 0;
    }

    private static int thrumLevel(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.THRUM.get()), (ItemStack)stack);
    }

    public int m_8105_(ItemStack stack) {
        return 720000;
    }

    public int getMaxCharge() {
        return 15;
    }

    public static int swingTimeMax() {
        return 7;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return super.canContinueUsing(oldStack, newStack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public void onHit(ItemStack stack, LivingEntity target, boolean isCharged) {
        if (isCharged) {
            if (GreatbladeItem.thrumLevel(stack) > 0) {
                GreatbladeItem.setThrum(stack, true);
            }
            int crushing = GreatbladeItem.crushingLevel(stack);
            target.m_7292_(new MobEffectInstance((MobEffect)AllEffects.STAGGERED.get(), (int)(25.0f * (1.0f + (float)crushing / 2.0f)), crushing, false, true));
        }
    }

    private static void setThrum(ItemStack stack, boolean value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(THRUM_KEY, value);
    }

    public static boolean hasThrum(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(THRUM_KEY)) {
            return tag.m_128471_(THRUM_KEY);
        }
        return false;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        super.onUsingTick(stack, player, count);
        if (GreatbladeItem.hasSailing(stack)) {
            float n = this.m_8105_(stack) - count;
            float speed = 1.0f;
            if (player.m_9236_().f_46443_) {
                LocalPlayer client = (LocalPlayer)player;
                Input input = client.f_108618_;
                if (input.f_108568_) {
                    speed = (float)((double)speed + 0.5);
                }
                if (input.f_108569_) {
                    speed = (float)((double)speed - 0.5);
                }
            }
            Vec3 accel = MiscHelper.extractHorizontal(player.m_20252_(1.0f)).m_82490_((double)(speed / ((n + 2.0f) / 3.0f)));
            if (n < 10.0f) {
                player.m_20334_(accel.f_82479_, player.m_20184_().f_82480_, accel.f_82481_);
                if (n % 2.0f == 0.0f) {
                    AttackHelper.makeParticleServer(player.f_19853_, AllParticles.SAILING_TRAIL, player.m_20182_().m_82520_(0.0, 1.0, 0.0));
                }
            }
            if (n > 15.0f) {
                player.m_21253_();
            }
        } else {
            float n = this.m_8105_(stack) - count;
            float threshold = 5.0f;
            float diff = (float)this.getMaxCharge() - n;
            if (diff > 0.0f && diff <= threshold) {
                Vec3 accel = player.m_20252_(1.0f);
                player.m_20256_(player.m_20184_().m_82549_(accel.m_82490_((double)(1.0f / threshold / 2.0f))));
            }
            if (n > (float)this.getMaxCharge()) {
                player.m_21253_();
            }
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int chargeTime = this.m_8105_(stack) - timeLeft;
            ItemStack sword = player.m_21211_();
            if (chargeTime >= this.getMaxCharge()) {
                GreatbladeSlashEntity slash = new GreatbladeSlashEntity(worldIn, sword, player.m_20182_().m_82520_(0.0, 0.0, 0.0), (Entity)player, GreatbladeItem.hasExecutioner(stack));
                slash.setDamage(this.baseDamage + this.getSlashDamage(stack));
                if (GreatbladeItem.hasThrum(stack)) {
                    slash.applyThrum();
                    GreatbladeItem.setThrum(stack, false);
                }
                slash.spriteFlip = player.m_5737_() == HumanoidArm.LEFT ^ player.m_7655_() == InteractionHand.OFF_HAND ? 1 : 0;
                slash.m_20256_(player.m_20252_(1.0f).m_82490_(2.0));
                slash.applyWhirlwind(EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.WHIRLING.get()), (ItemStack)stack));
                worldIn.m_7967_((Entity)slash);
                AttackHelper.playSound((Entity)player, SoundEvents.f_12317_, 1.0f, 0.5f);
                if (worldIn.f_46443_) {
                    ItemAnimator.startAnimation(player, sword, player.m_7655_(), new GreatbladeAnimation());
                    ItemAnimator.startAnimation(player, sword, player.m_7655_(), new GreatbladeThirdPersonAnimation());
                }
                Vec3 look = player.m_20252_(1.0f).m_82490_(1.0);
                player.m_5997_(look.f_82479_ / 2.0, 0.0, look.f_82481_ / 2.0);
                player.m_36334_();
                player.m_36335_().m_41524_(stack.m_41720_(), 20);
                InteractionHand otherHand = player.m_7655_() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                ItemStack otherStack = player.m_21120_(otherHand);
                if (!otherStack.m_41619_()) {
                    player.m_36335_().m_41524_(otherStack.m_41720_(), 10);
                }
                player.m_36399_(0.5f);
            }
        }
    }

    public void onSlashHit(ItemStack stack, LivingEntity target, Entity user) {
        AttackHelper.playSound(user, SoundEvents.f_12316_);
        if (user instanceof Player) {
            Player player = (Player)user;
        }
    }

    @Override
    public void onHandReset(ItemStack stack, LivingEntity user) {
        if (user instanceof Player && user.m_21252_() < this.getMaxCharge()) {
            Player player = (Player)user;
            if (GreatbladeItem.hasSailing(stack)) {
                player.m_20256_(player.m_20184_().m_82490_(0.5));
                player.m_36334_();
                player.m_36335_().m_41524_(stack.m_41720_(), 30);
                player.m_36399_(0.5f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    public IThirdPersonArmController.AnimType hasThirdPersonAnim(Player player, ItemStack stack, boolean isActive, InteractionHand hand) {
        if (isActive) {
            return IThirdPersonArmController.AnimType.OVERWRITES;
        }
        ItemAnimator.ItemAnimation animation = ItemAnimator.getAnimation(GreatbladeThirdPersonAnimation.class, player, hand);
        if (animation != null) {
            return IThirdPersonArmController.AnimType.OVERWRITES;
        }
        return IThirdPersonArmController.AnimType.FALSE;
    }

    @Override
    public <T extends LivingEntity> void doThirdPersonAnim(Player player, HumanoidModel<T> model, ItemStack itemStack, float partialTicks, boolean leftHanded, boolean isActive, InteractionHand hand) {
        ModelPart swordArm = leftHanded ? model.f_102812_ : model.f_102811_;
        ModelPart otherArm = leftHanded ? model.f_102811_ : model.f_102812_;
        int sideFlip = leftHanded ? -1 : 1;
        ItemAnimator.ItemAnimation animation = ItemAnimator.getAnimation(GreatbladeThirdPersonAnimation.class, player, hand);
        float swingProgress = 0.0f;
        if (animation != null) {
            swingProgress = animation.getProgress(partialTicks);
        }
        int useCount = player.m_21212_();
        int useDuration = this.m_8105_(itemStack);
        int useTime = useDuration - useCount;
        float chargePercent = Math.min(((float)useTime + partialTicks) / (float)this.getMaxCharge(), 1.0f);
        float chargeLerp = Math.min(chargePercent, 1.0f - swingProgress);
        swordArm.f_104203_ *= 0.4f * chargeLerp;
        swordArm.f_104203_ -= 0.4f * chargeLerp;
        swordArm.f_104204_ -= 0.3f * (float)sideFlip * chargeLerp;
        swordArm.f_104205_ += 0.3f * (float)sideFlip * chargeLerp;
        swordArm.f_104200_ += 1.0f * (float)sideFlip * chargeLerp;
        swordArm.f_104201_ += 4.0f * chargeLerp;
        swordArm.f_104202_ += 2.0f * chargeLerp;
        otherArm.f_104203_ *= 0.4f * chargeLerp;
        otherArm.f_104203_ -= 0.4f * chargeLerp;
        otherArm.f_104205_ += 0.9f * (float)sideFlip * chargeLerp;
        otherArm.f_104200_ -= 2.0f * (float)sideFlip * chargeLerp;
        otherArm.f_104201_ -= 2.0f * chargeLerp;
        otherArm.f_104202_ -= 3.0f * chargeLerp;
        model.f_102810_.f_104204_ += 0.3f * (float)sideFlip * chargeLerp;
        if (GreatbladeItem.hasSailing(itemStack) && useTime < 10) {
            model.f_102814_.f_104203_ = 0.0f;
            model.f_102813_.f_104203_ = 0.3f;
        }
        if (animation != null) {
            float pi = (float)Math.PI;
            float swingPercent = (float)Math.sin(Math.pow(animation.getProgress(partialTicks), 0.6) * (double)pi);
            swordArm.f_104203_ = (float)((double)swordArm.f_104203_ - 0.5 * (double)pi * (double)swingPercent);
            swordArm.f_104205_ = (float)((double)swordArm.f_104205_ + 0.4 * (double)pi * (double)swingPercent * (double)sideFlip);
            swordArm.f_104204_ = (float)((double)swordArm.f_104204_ + 0.1 * (double)pi * (double)swingPercent * (double)sideFlip);
            swordArm.f_104200_ += 2.5f * (float)sideFlip * swingPercent;
            swordArm.f_104201_ -= 6.0f * swingPercent;
            swordArm.f_104202_ -= 3.0f * swingPercent;
            otherArm.f_104203_ = (float)((double)otherArm.f_104203_ - 0.4 * (double)pi * (double)swingPercent);
            otherArm.f_104205_ = (float)((double)otherArm.f_104205_ + 0.4 * (double)pi * (double)swingPercent * (double)sideFlip);
            otherArm.f_104204_ = (float)((double)otherArm.f_104204_ + 0.1 * (double)pi * (double)swingPercent);
            otherArm.f_104200_ += 1.0f * (float)sideFlip * swingPercent;
            otherArm.f_104201_ += 3.0f * swingPercent;
            otherArm.f_104202_ += 4.5f * swingPercent;
            model.f_102810_.f_104204_ -= 0.2f * pi * swingPercent * (float)sideFlip;
        }
    }

    @Override
    public <T extends LivingEntity, M extends EntityModel<T>> boolean onThirdPersonRender(M model, LivingEntity entity, ItemStack itemStack, ItemTransforms.TransformType transformType, HumanoidArm side, PoseStack poseStack, MultiBufferSource renderBuffer, int light) {
        InteractionHand swordHand;
        Player player;
        ItemAnimator.ItemAnimation animation;
        if (entity instanceof Player && (animation = ItemAnimator.getAnimation(GreatbladeThirdPersonAnimation.class, player = (Player)entity, swordHand = MiscHelper.getHandFromSide(player, side))) != null) {
            float progress = animation.getProgress(Minecraft.m_91087_().m_91296_());
            float pi = (float)Math.PI;
            float sineProgress = (float)Math.sin(progress * pi);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(sineProgress * 180.0f));
            poseStack.m_85837_(0.0, (double)sineProgress * 0.25, (double)sineProgress * -0.25);
        }
        return false;
    }

    public static class GreatbladeAnimation
    extends ItemAnimator.SimpleItemAnimation {
        public GreatbladeAnimation() {
            super(GreatbladeItem.swingTimeMax());
        }
    }

    public static class GreatbladeThirdPersonAnimation
    extends ItemAnimator.SimpleItemAnimation {
        public GreatbladeThirdPersonAnimation() {
            super(GreatbladeItem.swingTimeMax() + 4);
        }
    }
}

