/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.weapons;

import com.jsburg.clash.enchantments.spear.DashEnchantment;
import com.jsburg.clash.registry.AllSounds;
import com.jsburg.clash.weapons.util.AttackHelper;
import com.jsburg.clash.weapons.util.ISpearAnimation;
import com.jsburg.clash.weapons.util.IThirdPersonArmController;
import com.jsburg.clash.weapons.util.WeaponItem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class JumpRodItem
extends WeaponItem
implements IThirdPersonArmController,
ISpearAnimation {
    private static final int maxCharge = 18;
    private static final int minCharge = 5;

    public JumpRodItem(float attackDamage, float attackSpeed, Item.Properties properties) {
        super(attackDamage, attackSpeed, properties);
    }

    public int m_8105_(ItemStack stack) {
        return 720000;
    }

    @Override
    protected List<Enchantment> vanillaEnchantments() {
        return Arrays.asList(Enchantments.f_44980_, Enchantments.f_44981_);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            boolean doThrust;
            Player player = (Player)entityLiving;
            int chargeTime = this.m_8105_(stack) - timeLeft;
            ItemStack rod = player.m_21211_();
            float chargePercent = Math.min((float)chargeTime / 18.0f, 1.0f);
            boolean bl = doThrust = !player.m_6144_() && chargeTime > 5 && player.m_20096_() && !player.m_6069_();
            if (doThrust) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                player.m_6674_(player.m_7655_());
                AttackHelper.playSound((Entity)player, (SoundEvent)AllSounds.WEAPON_SPEAR_WHOOSH.get(), 0.3f, 1.0f);
                double boostedPercentage = Math.min(1.0, (double)chargePercent * 1.4);
                Vec3 dir = player.m_20154_().m_82490_(2.0 * boostedPercentage);
                player.m_5997_(dir.f_82479_, dir.f_82480_ / 2.0 + 0.2, dir.f_82481_);
                AttackHelper.damageItem(1, rod, player, player.m_7655_());
                player.m_36399_(0.1f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        DashEnchantment.tryAgilityDash(worldIn, playerIn, stack);
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    public IThirdPersonArmController.AnimType hasThirdPersonAnim(Player player, ItemStack stack, boolean isActive, InteractionHand hand) {
        return IThirdPersonArmController.AnimType.ifTrue(isActive);
    }

    @Override
    public <T extends LivingEntity> void doThirdPersonAnim(Player player, HumanoidModel<T> model, ItemStack itemStack, float partialTicks, boolean leftHanded, boolean isActive, InteractionHand hand) {
        ModelPart spearArm = leftHanded ? model.f_102812_ : model.f_102811_;
        int sideFlip = leftHanded ? -1 : 1;
        spearArm.f_104203_ *= 0.4f;
        spearArm.f_104203_ += 0.4f;
        spearArm.f_104204_ += 0.3f * (float)sideFlip;
        spearArm.f_104205_ += 0.3f * (float)sideFlip;
        spearArm.f_104200_ += 1.0f * (float)sideFlip;
        spearArm.f_104201_ += 4.0f;
        spearArm.f_104202_ += 2.0f;
        model.f_102810_.f_104204_ += 0.3f * (float)sideFlip;
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        return 18;
    }
}

