/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.weapons;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jsburg.clash.enchantments.spear.DashEnchantment;
import com.jsburg.clash.registry.AllEnchantments;
import com.jsburg.clash.registry.AllParticles;
import com.jsburg.clash.registry.AllSounds;
import com.jsburg.clash.util.TextHelper;
import com.jsburg.clash.weapons.util.AttackHelper;
import com.jsburg.clash.weapons.util.ISpearAnimation;
import com.jsburg.clash.weapons.util.IThirdPersonArmController;
import com.jsburg.clash.weapons.util.WeaponItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpearItem
extends WeaponItem
implements ISpearAnimation,
IThirdPersonArmController {
    private static final Vec3 UP = new Vec3(0.0, 1.0, 0.0);
    private static final float stabLengthBonus = 2.5f;
    private static final float sweetSpotSize = 2.5f;
    private final List<Multimap<Attribute, AttributeModifier>> flurryAttributes;

    public SpearItem(float attackDamage, float attackSpeed, Item.Properties properties) {
        super(attackDamage, attackSpeed, properties);
        attackDamage -= 1.0f;
        attackSpeed = -(4.0f - attackSpeed);
        ArrayList<Multimap<Attribute, AttributeModifier>> multimaps = new ArrayList<Multimap<Attribute, AttributeModifier>>();
        for (int i = 1; i <= 4; ++i) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)(attackSpeed + 0.2f * (float)i), AttributeModifier.Operation.ADDITION));
            multimaps.add((Multimap<Attribute, AttributeModifier>)builder.build());
        }
        this.flurryAttributes = multimaps;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"item.clash.spear.when_charged").m_130940_(ChatFormatting.GRAY));
        tooltip.add(TextHelper.getBonusText("item.clash.spear.charge_range_bonus", 2.5f));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        int flurry = Math.min(EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.FLURRY.get()), (ItemStack)stack), 4);
        if (slot == EquipmentSlot.MAINHAND && flurry > 0) {
            return this.flurryAttributes.get(flurry - 1);
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public List<Enchantment> vanillaEnchantments() {
        return Arrays.asList(Enchantments.f_44982_, Enchantments.f_44956_);
    }

    public int m_8105_(ItemStack stack) {
        return 720000;
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.JAB.get()), (ItemStack)stack) > 0) {
            return 3;
        }
        return 20;
    }

    public int getMinCharge(ItemStack stack) {
        if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.JAB.get()), (ItemStack)stack) > 0) {
            return 0;
        }
        return 10 - EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.FLURRY.get()), (ItemStack)stack);
    }

    protected void onStabHit(ItemStack stack, Player player, LivingEntity target, float chargePercent) {
        Vec3 look = player.m_20154_();
        target.m_147240_((double)(chargePercent / 3.0f), -look.m_7096_(), -look.m_7094_());
    }

    protected boolean canStabCrit(ItemStack stack) {
        return true;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            boolean hasJab;
            Player player = (Player)entityLiving;
            int chargeTime = this.m_8105_(stack) - timeLeft;
            ItemStack spear = player.m_21211_();
            float chargePercent = Math.min((float)chargeTime / (float)this.getMaxCharge(spear), 1.0f);
            boolean bl = hasJab = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.JAB.get()), (ItemStack)stack) > 0;
            if (chargeTime >= this.getMinCharge(stack)) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                player.m_6674_(player.m_7655_());
                if (hasJab) {
                    ItemCooldowns tracker = player.m_36335_();
                    tracker.m_41527_((Item)this);
                    tracker.m_41524_((Item)this, 40);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1));
                }
                double stabLength = AttackHelper.getAttackRange(player) + 2.5;
                Vec3 look = player.m_20154_();
                Vec3 endVec = look.m_82490_(stabLength);
                Vec3 eyePos = player.m_20299_(1.0f);
                Vec3 endPos = eyePos.m_82549_(endVec);
                AABB boundingBox = new AABB(eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_, endPos.f_82479_, endPos.f_82480_, endPos.f_82481_).m_82400_(1.0);
                Predicate<Entity> predicate = e -> !e.m_5833_() && e.m_6087_();
                EntityHitResult rayTraceResult = AttackHelper.rayTraceWithMotion(worldIn, (Entity)player, eyePos, endPos, boundingBox, predicate);
                Vec3 side = look.m_82537_(UP).m_82490_(0.75);
                if (player.m_5737_() == HumanoidArm.LEFT ^ player.m_7655_() == InteractionHand.OFF_HAND) {
                    side = side.m_82490_(-1.0);
                }
                side = side.m_82549_(eyePos).m_82546_(UP.m_82490_(0.2));
                if (rayTraceResult != null) {
                    Entity target = rayTraceResult.m_82443_();
                    Vec3 hitLocation = rayTraceResult.m_82450_();
                    BlockHitResult blockRayTraceResult = player.f_19853_.m_45547_(new ClipContext(eyePos, hitLocation, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                    if (blockRayTraceResult.m_6662_() == HitResult.Type.MISS && !worldIn.f_46443_) {
                        boolean canAttack;
                        if (target instanceof EnderDragonPart) {
                            target = ((EnderDragonPart)target).f_31010_;
                        }
                        if (canAttack = AttackHelper.fullAttackEntityCheck(player, target)) {
                            double distance;
                            float damage = (float)AttackHelper.getAttackDamage(spear, player, EquipmentSlot.MAINHAND);
                            if (this.canStabCrit(stack) && chargeTime > this.getMaxCharge(stack) - 4) {
                                damage *= AttackHelper.getCrit(player, target, true);
                            }
                            player.m_36334_();
                            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.SWEET_SPOT.get()), (ItemStack)spear) > 0 && (distance = endPos.m_82554_(hitLocation)) <= 2.5) {
                                damage *= 2.0f;
                                AttackHelper.playSound((Entity)player, (SoundEvent)AllSounds.WEAPON_SPEAR_MEGA_CRIT.get(), 2.0f, 1.0f);
                                for (int i = 0; i <= 5; ++i) {
                                    RandomSource rand = worldIn.m_213780_();
                                    Vec3 motion = new Vec3(rand.m_188500_() - 0.5, rand.m_188500_() - 0.5, rand.m_188500_() - 0.5);
                                    AttackHelper.makeParticleServer((ServerLevel)worldIn, (SimpleParticleType)AllParticles.SPEAR_CRIT.get(), hitLocation, motion, 1.5);
                                }
                            }
                            AttackHelper.attackEntity(player, target, damage += AttackHelper.getBonusEnchantmentDamage(spear, target));
                            AttackHelper.doHitStuff(player, target, spear);
                            AttackHelper.playSound((Entity)player, SoundEvents.f_12316_);
                            this.onStabHit(stack, player, (LivingEntity)target, chargePercent);
                        }
                        player.m_36399_(0.2f);
                    }
                }
                AttackHelper.playSound((Entity)player, (SoundEvent)AllSounds.WEAPON_SPEAR_STAB.get());
                AttackHelper.makeParticle(player.m_20193_(), (SimpleParticleType)AllParticles.SPEAR_STAB.get(), side.m_82549_(look), side.m_82505_(endPos), 1.4);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        DashEnchantment.tryAgilityDash(worldIn, playerIn, stack);
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    public IThirdPersonArmController.AnimType hasThirdPersonAnim(Player player, ItemStack stack, boolean isActive, InteractionHand hand) {
        return IThirdPersonArmController.AnimType.ifTrue(isActive);
    }

    @Override
    public <T extends LivingEntity> void doThirdPersonAnim(Player player, HumanoidModel<T> model, ItemStack itemStack, float partialTicks, boolean leftHanded, boolean isActive, InteractionHand hand) {
        ModelPart spearArm = leftHanded ? model.f_102812_ : model.f_102811_;
        ModelPart otherArm = leftHanded ? model.f_102811_ : model.f_102812_;
        int sideFlip = leftHanded ? -1 : 1;
        spearArm.f_104203_ *= 0.4f;
        spearArm.f_104203_ -= 0.4f;
        spearArm.f_104204_ -= 0.3f * (float)sideFlip;
        spearArm.f_104205_ += 0.3f * (float)sideFlip;
        spearArm.f_104200_ += 1.0f * (float)sideFlip;
        spearArm.f_104201_ += 4.0f;
        spearArm.f_104202_ += 2.0f;
        otherArm.f_104203_ *= 0.4f;
        otherArm.f_104203_ -= 0.4f;
        otherArm.f_104205_ += 0.9f * (float)sideFlip;
        otherArm.f_104200_ -= 2.0f * (float)sideFlip;
        otherArm.f_104201_ -= 2.0f;
        otherArm.f_104202_ -= 3.0f;
        model.f_102810_.f_104204_ += 0.3f * (float)sideFlip;
    }
}

