/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.weapons;

import com.jsburg.clash.registry.AllEffects;
import com.jsburg.clash.registry.AllParticles;
import com.jsburg.clash.util.ScreenShaker;
import com.jsburg.clash.weapons.util.AttackHelper;
import com.jsburg.clash.weapons.util.WeaponItem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;

public class SweptAxeItem
extends WeaponItem {
    public SweptAxeItem(int attackDamage, float attackSpeed, Item.Properties properties) {
        super(attackDamage, attackSpeed, properties);
    }

    @Override
    public List<Enchantment> vanillaEnchantments() {
        return Arrays.asList(Enchantments.f_44982_);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment instanceof DamageEnchantment) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        if (AttackHelper.weaponIsCharged(player)) {
            MobEffectInstance retaliation = player.m_21124_((MobEffect)AllEffects.RETALIATION.get());
            Vec3 eyepos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
            AttackHelper.makeParticle(target.f_19853_, (SimpleParticleType)AllParticles.AXE_SWEEP.get(), target.m_20182_().m_82549_(eyepos).m_82490_(0.5), 0.5, retaliation != null ? 1.0 : 0.0, player.m_5737_() == HumanoidArm.LEFT ? 1.0 : 0.0);
            Vec3 look = player.m_20154_();
            float damage = (float)player.m_21133_(Attributes.f_22281_);
            int hits = 1;
            for (LivingEntity livingentity : player.f_19853_.m_45976_(LivingEntity.class, target.m_20191_().m_82377_(1.5, 0.5, 1.5))) {
                if (livingentity == player || livingentity == target || player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(player.m_20280_((Entity)livingentity) < 12.0) || livingentity instanceof TamableAnimal && ((TamableAnimal)livingentity).m_21830_((LivingEntity)player)) continue;
                if (!player.f_19853_.f_46443_) {
                    livingentity.m_147240_((double)0.4f, -look.m_7096_(), -look.m_7094_());
                    float bonus = AttackHelper.getBonusEnchantmentDamage(stack, (Entity)livingentity);
                    if (livingentity.m_6469_(DamageSource.m_19344_((Player)player), damage + bonus) && bonus > 0.0f) {
                        player.m_5700_((Entity)livingentity);
                    }
                }
                ++hits;
            }
            if (player.f_19853_.f_46443_ && hits >= 3) {
                ScreenShaker.setScreenShake(4, 2.0);
            }
            AttackHelper.playSound((Entity)player, SoundEvents.f_12317_, 1.0f, 0.7f);
        }
        return false;
    }
}

