/*
 * Decompiled with CFR 0.152.
 */
package com.jsburg.clash.weapons.util;

import com.google.common.collect.Multimap;
import com.jsburg.clash.weapons.util.IHitListener;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.registries.RegistryObject;

public class AttackHelper {
    public static boolean canAttackEntity(Player player, Entity targetEntity) {
        return targetEntity.m_6097_() && !targetEntity.m_7313_((Entity)player);
    }

    public static boolean fullAttackEntityCheck(Player player, Entity targetEntity) {
        if (!ForgeHooks.onPlayerAttackTarget((Player)player, (Entity)targetEntity)) {
            return false;
        }
        return AttackHelper.canAttackEntity(player, targetEntity);
    }

    public static boolean weaponIsCharged(Player player) {
        return player.m_36403_(0.5f) > 0.9f;
    }

    public static void playSound(Entity player, SoundEvent sound) {
        AttackHelper.playSound(player, sound, 1.0f, 1.0f);
    }

    public static void playSound(Entity player, SoundEvent sound, float volume, float pitch) {
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, player.m_5720_(), volume, pitch);
    }

    public static void doHitStuff(Player player, Entity target, ItemStack weapon) {
        AttackHelper.doHitStuff(player, target, weapon, player.m_7655_());
    }

    public static void doHitStuff(Player player, Entity target, ItemStack weapon, InteractionHand hand) {
        if (target instanceof EnderDragonPart) {
            target = ((EnderDragonPart)target).f_31010_;
        }
        if (!player.f_19853_.f_46443_ && target instanceof LivingEntity) {
            ItemStack copy = weapon.m_41777_();
            weapon.m_41640_((LivingEntity)target, player);
            if (weapon.m_41720_() instanceof IHitListener) {
                ((IHitListener)weapon.m_41720_()).onHit(weapon, (LivingEntity)target, true);
            }
            if (weapon.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)hand);
                player.m_21008_(hand, ItemStack.f_41583_);
            }
        }
    }

    public static void damageItem(int damage, ItemStack item, Player player) {
        AttackHelper.damageItem(damage, item, player, InteractionHand.MAIN_HAND);
    }

    public static void damageItem(int damage, ItemStack item, Player player, InteractionHand hand) {
        item.m_41622_(damage, (LivingEntity)player, p -> {
            p.m_21190_(hand);
            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)item, (InteractionHand)hand);
        });
    }

    public static double getAttackRange(Player player) {
        if (player.m_7500_()) {
            return 5.0;
        }
        return player.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get());
    }

    public static void attackEntity(Player player, Entity target, float damage) {
        float lastHealth = 0.0f;
        if (target instanceof LivingEntity) {
            lastHealth = ((LivingEntity)target).m_21223_();
        }
        target.m_6469_(DamageSource.m_19344_((Player)player), damage);
        if (target instanceof LivingEntity) {
            float healthDifference = lastHealth - ((LivingEntity)target).m_21223_();
            player.m_36222_(Stats.f_12928_, Math.round(healthDifference * 10.0f));
            if (player.f_19853_ instanceof ServerLevel && healthDifference > 2.0f) {
                int k = (int)((double)healthDifference * 0.5);
                ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
            }
        }
    }

    public static float getBonusEnchantmentDamage(ItemStack item, Entity target) {
        float bonus = target instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)item, (MobType)((LivingEntity)target).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)item, (MobType)MobType.f_21640_);
        return bonus;
    }

    public static float getCrit(Player player, Entity target, boolean shouldCrit) {
        return AttackHelper.getCrit(player, target, shouldCrit, true, true);
    }

    public static float getCrit(Player player, Entity target, boolean shouldCrit, boolean doEffects, boolean playCritSound) {
        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)shouldCrit, (float)(shouldCrit ? 1.5f : 1.0f));
        if (hitResult == null) {
            return 1.0f;
        }
        if (hitResult.getDamageModifier() > 1.0f && doEffects) {
            if (playCritSound) {
                AttackHelper.playSound((Entity)player, SoundEvents.f_12313_);
            }
            player.m_5704_(target);
        }
        return hitResult.getDamageModifier();
    }

    public static void makeParticle(Level world, SimpleParticleType particle, Vec3 position, Vec3 motion, double speed) {
        motion = motion.m_82541_().m_82490_(speed);
        world.m_7106_((ParticleOptions)particle, position.m_7096_(), position.m_7098_(), position.m_7094_(), motion.m_7096_(), motion.m_7098_(), motion.m_7094_());
    }

    public static void makeParticle(Level world, SimpleParticleType particle, Vec3 position, double xSpeed, double ySpeed, double zSpeed) {
        world.m_7106_((ParticleOptions)particle, position.m_7096_(), position.m_7098_(), position.m_7094_(), xSpeed, ySpeed, zSpeed);
    }

    public static void makeParticle(Level world, SimpleParticleType particle, Vec3 position) {
        AttackHelper.makeParticle(world, particle, position, Vec3.f_82478_, 0.0);
    }

    public static void makeParticleServer(ServerLevel world, SimpleParticleType particle, Vec3 position, Vec3 motion, double speed) {
        motion = motion.m_82541_().m_82490_(speed);
        world.m_8767_((ParticleOptions)particle, position.m_7096_(), position.m_7098_(), position.m_7094_(), 0, motion.m_7096_(), motion.m_7098_(), motion.m_7094_(), speed);
    }

    public static void makeParticleServer(Level world, RegistryObject<SimpleParticleType> particle, Vec3 position) {
        if (world.m_5776_()) {
            return;
        }
        ((ServerLevel)world).m_8767_((ParticleOptions)((SimpleParticleType)particle.get()), position.m_7096_(), position.m_7098_(), position.m_7094_(), 0, 0.0, 0.0, 0.0, 0.0);
    }

    public static void makeParticleServer(Level world, RegistryObject<SimpleParticleType> particle, Vec3 position, double xSpeed, double ySpeed, double zSpeed) {
        if (world.m_5776_()) {
            return;
        }
        ((ServerLevel)world).m_8767_((ParticleOptions)((SimpleParticleType)particle.get()), position.m_7096_(), position.m_7098_(), position.m_7094_(), 0, xSpeed, ySpeed, zSpeed, 1.0);
    }

    public static double getAttackDamage(ItemStack item, Player player, EquipmentSlot equipmentSlot) {
        Multimap multimap = item.m_41638_(equipmentSlot);
        for (Map.Entry entry : multimap.entries()) {
            if (!((Attribute)entry.getKey()).equals(Attributes.f_22281_)) continue;
            return ((AttributeModifier)entry.getValue()).m_22218_() + player.m_21172_(Attributes.f_22281_);
        }
        return player.m_21172_(Attributes.f_22281_);
    }

    @Nullable
    public static EntityHitResult rayTraceWithMotion(Level worldIn, Entity projectile, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        Vec3 hitVec = null;
        for (Entity target : worldIn.m_6249_(projectile, boundingBox, filter)) {
            double d1;
            Vec3 targetMotion = target.m_20184_().m_82490_(0.5);
            AABB entityBox = target.m_20191_().m_82369_(targetMotion).m_82369_(targetMotion.m_82548_());
            Optional optional = entityBox.m_82371_(startVec, endVec);
            if (!optional.isPresent() || !((d1 = startVec.m_82557_((Vec3)optional.get())) < d0)) continue;
            hitVec = (Vec3)optional.get();
            entity = target;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, hitVec);
    }

    public static Vec3 getEntityPosition(Entity target) {
        return new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
    }
}

