/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.clayworks.core.ClayworksConfig;
import com.teamabnormals.clayworks.core.data.client.ClayworksBlockStateProvider;
import com.teamabnormals.clayworks.core.data.client.ClayworksLanguageProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksLootTableProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksRecipeProvider;
import com.teamabnormals.clayworks.core.data.server.tags.ClayworksBlockTagsProvider;
import com.teamabnormals.clayworks.core.data.server.tags.ClayworksItemTagsProvider;
import com.teamabnormals.clayworks.core.data.server.tags.ClayworksPaintingVariantTagsProvider;
import com.teamabnormals.clayworks.core.registry.ClayworksLootConditions;
import com.teamabnormals.clayworks.core.registry.ClayworksMenuTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksPaintingVariants;
import com.teamabnormals.clayworks.core.registry.ClayworksParticleTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksRecipes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="clayworks")
public class Clayworks {
    public static final String MOD_ID = "clayworks";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("clayworks");
    public static final RecipeBookType RECIPE_TYPE_BAKING = RecipeBookType.create((String)"BAKING");

    public Clayworks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        ClayworksLootConditions.LOOT_CONDITION_TYPES.register(bus);
        ClayworksMenuTypes.MENU_TYPES.register(bus);
        ClayworksRecipes.ClayworksRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        ClayworksRecipes.ClayworksRecipeTypes.RECIPE_TYPES.register(bus);
        ClayworksParticleTypes.PARTICLE_TYPES.register(bus);
        ClayworksPaintingVariants.PAINTING_VARIANTS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ClayworksConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ClayworksMenuTypes.registerScreenFactories());
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        ClayworksBlockTagsProvider blockTags = new ClayworksBlockTagsProvider(generator, helper);
        generator.m_236039_(includeServer, (DataProvider)blockTags);
        generator.m_236039_(includeServer, (DataProvider)new ClayworksItemTagsProvider(generator, blockTags, helper));
        generator.m_236039_(includeServer, (DataProvider)new ClayworksLootTableProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new ClayworksRecipeProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new ClayworksPaintingVariantTagsProvider(generator, helper));
        boolean includeClient = event.includeServer();
        generator.m_236039_(includeClient, (DataProvider)new ClayworksBlockStateProvider(generator, helper));
        generator.m_236039_(includeClient, (DataProvider)new ClayworksLanguageProvider(generator));
    }
}

