/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.mixin.DamageSourceAccessor;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.api.PlayerKnockedOutEvent;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.capability.InvalidHardcoreRevivalData;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfigData;
import net.blay09.mods.hardcorerevival.handler.KnockoutSyncHandler;
import net.blay09.mods.hardcorerevival.mixin.ServerPlayerAccessor;
import net.blay09.mods.hardcorerevival.network.RevivalProgressMessage;
import net.blay09.mods.hardcorerevival.network.RevivalSuccessMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardcoreRevivalManager {
    public static final DamageSource notRescuedInTime = HardcoreRevivalManager.createNotRescuedInTimeDamageSource();

    @NotNull
    private static DamageSource createNotRescuedInTimeDamageSource() {
        DamageSource damageSource = DamageSourceAccessor.create((String)"not_rescued_in_time");
        DamageSourceAccessor damageSourceAccessor = (DamageSourceAccessor)damageSource;
        damageSourceAccessor.callBypassMagic();
        damageSourceAccessor.callBypassArmor();
        damageSourceAccessor.callBypassInvul();
        return damageSource;
    }

    public HardcoreRevivalData getRevivalData(Player player) {
        HardcoreRevivalData provider = (HardcoreRevivalData)Balm.getProviders().getProvider((Entity)player, HardcoreRevivalData.class);
        return provider != null ? provider : InvalidHardcoreRevivalData.INSTANCE;
    }

    public void knockout(Player player, DamageSource source) {
        MinecraftServer server;
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        if (revivalData.isKnockedOut()) {
            return;
        }
        player.m_21195_(MobEffects.f_19605_);
        revivalData.setKnockedOut(true);
        revivalData.setKnockoutTicksPassed(0);
        Balm.getEvents().fireEvent((Object)new PlayerKnockedOutEvent(player, source));
        if (player.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && (server = player.m_20194_()) != null) {
            Team team = player.m_5647_();
            if (team != null && team.m_7468_() != Team.Visibility.ALWAYS) {
                if (team.m_7468_() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                    server.m_6846_().m_215621_(player, player.m_21231_().m_19293_());
                } else if (team.m_7468_() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                    server.m_6846_().m_215649_(player, player.m_21231_().m_19293_());
                }
            } else {
                server.m_6846_().m_240416_(player.m_21231_().m_19293_(), false);
            }
        }
        this.updateKnockoutEffects(player);
    }

    public void wakeup(Player player) {
        this.wakeup(player, true);
    }

    public void wakeup(Player player, boolean applyEffects) {
        this.reset(player);
        if (applyEffects) {
            HardcoreRevivalConfigData config = HardcoreRevivalConfig.getActive();
            player.m_21153_((float)config.rescueRespawnHealth);
            player.m_36324_().m_38705_(config.rescueRespawnFoodLevel);
            for (String effectString : config.rescueRespawnEffects) {
                String[] parts = effectString.split("\\|");
                ResourceLocation registryName = ResourceLocation.m_135820_((String)parts[0]);
                if (registryName != null) {
                    MobEffect effect = Balm.getRegistries().getMobEffect(registryName);
                    if (effect != null) {
                        int duration = this.tryParseInt(parts.length >= 2 ? parts[1] : null, 600);
                        int amplifier = this.tryParseInt(parts.length >= 3 ? parts[2] : null, 0);
                        player.m_7292_(new MobEffectInstance(effect, duration, amplifier));
                        continue;
                    }
                    HardcoreRevival.logger.info("Invalid rescue potion effect '{}'" + parts[0]);
                    continue;
                }
                HardcoreRevival.logger.info("Invalid rescue potion effect '{}'" + parts[0]);
            }
        }
    }

    private int tryParseInt(@Nullable String text, int defaultVal) {
        if (text != null) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public void finishRescue(Player player) {
        MinecraftServer server;
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        Player rescueTarget = revivalData.getRescueTarget();
        if (rescueTarget != null && (server = rescueTarget.m_20194_()) != null) {
            this.wakeup(rescueTarget);
            Balm.getNetworking().sendTo(player, (Object)new RevivalProgressMessage(rescueTarget.m_19879_(), -1.0f));
            Balm.getNetworking().sendTo(rescueTarget, (Object)new RevivalSuccessMessage(rescueTarget.m_19879_()));
            Balm.getNetworking().sendToTracking((Entity)rescueTarget, (Object)new RevivalSuccessMessage(rescueTarget.m_19879_()));
            revivalData.setRescueTarget(null);
        }
        Balm.getHooks().setForcedPose(player, null);
    }

    public void abortRescue(Player player) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        Player rescueTarget = revivalData.getRescueTarget();
        if (rescueTarget != null) {
            revivalData.setRescueTime(0);
            revivalData.setRescueTarget(null);
            Balm.getNetworking().sendTo(player, (Object)new RevivalProgressMessage(-1, -1.0f));
            KnockoutSyncHandler.sendHardcoreRevivalData(rescueTarget, (Entity)rescueTarget, this.getRevivalData(rescueTarget));
            Balm.getHooks().setForcedPose(player, null);
        }
    }

    public void notRescuedInTime(Player player) {
        if (player instanceof ServerPlayerAccessor) {
            ServerPlayerAccessor accessor = (ServerPlayerAccessor)player;
            accessor.setSpawnInvulnerableTime(0);
        }
        player.m_6469_(notRescuedInTime, Float.MAX_VALUE);
        this.reset(player);
    }

    public void reset(Player player) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        revivalData.setKnockedOut(false);
        revivalData.setKnockoutTicksPassed(0);
        this.updateKnockoutEffects(player);
    }

    public void updateKnockoutEffects(Player player) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        if (HardcoreRevivalConfig.getActive().glowOnKnockout) {
            player.m_146915_(revivalData.isKnockedOut());
        }
        Balm.getHooks().setForcedPose(player, (Pose)(revivalData.isKnockedOut() ? Pose.FALL_FLYING : null));
        KnockoutSyncHandler.sendHardcoreRevivalDataToWatching(player, revivalData);
    }

    public void startRescue(Player player, Player target) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        revivalData.setRescueTarget(target);
        revivalData.setRescueTime(0);
        Balm.getNetworking().sendTo(player, (Object)new RevivalProgressMessage(target.m_19879_(), 0.1f));
        KnockoutSyncHandler.sendHardcoreRevivalData(target, (Entity)target, this.getRevivalData(target), true);
        Balm.getHooks().setForcedPose(player, Pose.CROUCHING);
    }

    public boolean isRescuing(Player player) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        Player rescueTarget = revivalData.getRescueTarget();
        return rescueTarget != null;
    }

    boolean isKnockedOut(Player player) {
        return this.getRevivalData(player).isKnockedOut();
    }
}

