/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.config;

import com.google.common.collect.Lists;
import java.util.List;
import me.shedaniel.autoconfig.annotation.Config;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.config.ExpectedType;
import net.blay09.mods.balm.api.config.Synced;

@Config(name="hardcorerevival")
public class HardcoreRevivalConfigData
implements BalmConfigData {
    @Comment(value="The time in ticks in which a player can still be rescued from death. Set to 0 to disable the timer.")
    @Synced
    public int ticksUntilDeath = 2400;
    @Comment(value="If true, the timer until death continues even if the player logs out.")
    public boolean continueTimerWhileOffline = false;
    @Comment(value="The time in ticks it takes to rescue a player.")
    @Synced
    public int rescueActionTicks = 40;
    @Comment(value="The amount of health to respawn with when a player was rescued, out of 20.")
    public int rescueRespawnHealth = 1;
    @Comment(value="The food level to respawn with when a player was rescued, out of 20.")
    public int rescueRespawnFoodLevel = 5;
    @ExpectedType(value=String.class)
    @Comment(value="Effects applied to a player when rescued, in the format \"effect|duration|amplifier\"")
    public List<String> rescueRespawnEffects = Lists.newArrayList((Object[])new String[]{"minecraft:hunger|600|0", "minecraft:weakness|1200|0"});
    @Comment(value="The distance at which a player can rescue another.")
    @Synced
    public double rescueDistance = 5.0;
    @Comment(value="If true, knocked out players will glow, making them visible through blocks.")
    public boolean glowOnKnockout = true;
    @Comment(value="If true, knocked out players are still able to punch nearby enemies.")
    @Synced
    public boolean allowUnarmedMelee = false;
    @Comment(value="If true, knocked out players are still able to fire bows.")
    @Synced
    public boolean allowBows = false;
    @Comment(value="If true, knocked out players are still able to fire pistols from Mr Crayfish's Gun Mod.")
    @Synced
    public boolean allowPistols = false;
}

