/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.mixin.LivingEntityAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public class KnockoutHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(LivingDamageEvent.class, KnockoutHandler::onPlayerDamage);
        Balm.getEvents().onEvent(PlayerRespawnEvent.class, KnockoutHandler::onPlayerRespawn);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, KnockoutHandler::onPlayerTick);
    }

    public static void onPlayerDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            boolean canDamageSourceKnockout;
            ServerPlayer player = (ServerPlayer)livingEntity;
            DamageSource damageSource = event.getDamageSource();
            if (HardcoreRevival.getRevivalData((Entity)event.getEntity()).isKnockedOut()) {
                Entity attacker = damageSource.m_7639_();
                if (attacker instanceof Mob) {
                    Mob mob = (Mob)attacker;
                    mob.m_6710_(null);
                }
                if (!damageSource.m_19378_() && damageSource != HardcoreRevivalManager.notRescuedInTime) {
                    event.setCanceled(true);
                }
                return;
            }
            boolean bl = canDamageSourceKnockout = damageSource != DamageSource.f_19317_ && damageSource != HardcoreRevivalManager.notRescuedInTime;
            if (canDamageSourceKnockout && player.m_21223_() - event.getDamageAmount() <= 0.0f) {
                event.setDamageAmount(Math.min(event.getDamageAmount(), Math.max(0.0f, player.m_21223_() - 1.0f)));
                if (((LivingEntityAccessor)player).callCheckTotemDeathProtection(damageSource)) {
                    event.setCanceled(true);
                } else {
                    HardcoreRevival.getManager().knockout((Player)player, damageSource);
                }
            }
        }
    }

    public static void onPlayerTick(ServerPlayer player) {
        HardcoreRevivalData revivalData = HardcoreRevival.getRevivalData((Entity)player);
        if (revivalData.isKnockedOut() && player.m_6084_()) {
            player.m_21153_(1.0f);
            revivalData.setKnockoutTicksPassed(revivalData.getKnockoutTicksPassed() + 1);
            int maxTicksUntilDeath = HardcoreRevivalConfig.getActive().ticksUntilDeath;
            if (maxTicksUntilDeath > 0 && revivalData.getKnockoutTicksPassed() >= maxTicksUntilDeath) {
                HardcoreRevival.getManager().notRescuedInTime((Player)player);
            }
        }
    }

    public static void onPlayerRespawn(PlayerRespawnEvent event) {
        HardcoreRevival.getManager().reset((Player)event.getNewPlayer());
    }
}

