/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LivingHealEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class KnockoutRestrictionHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(UseBlockEvent.class, KnockoutRestrictionHandler::onUseBlock, EventPriority.Highest);
        Balm.getEvents().onEvent(UseItemEvent.class, KnockoutRestrictionHandler::onUseItem, EventPriority.Highest);
        Balm.getEvents().onEvent(TossItemEvent.class, KnockoutRestrictionHandler::onTossItem, EventPriority.Highest);
        Balm.getEvents().onEvent(PlayerAttackEvent.class, KnockoutRestrictionHandler::onAttack, EventPriority.Highest);
        Balm.getEvents().onEvent(DigSpeedEvent.class, KnockoutRestrictionHandler::onDigSpeed, EventPriority.Highest);
        Balm.getEvents().onEvent(LivingHealEvent.class, KnockoutRestrictionHandler::onHeal);
    }

    public static void onHeal(LivingHealEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && HardcoreRevival.getRevivalData((Entity)(player = (Player)livingEntity)).isKnockedOut()) {
            event.setCanceled(false);
        }
    }

    public static void onDigSpeed(DigSpeedEvent event) {
        Player player = event.getPlayer();
        if (player != null && HardcoreRevival.getRevivalData((Entity)player).isKnockedOut()) {
            event.setSpeedOverride(Float.valueOf(0.0f));
            event.setCanceled(true);
        }
    }

    public static void onUseBlock(UseBlockEvent event) {
        Player player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((Entity)player).isKnockedOut()) {
            ItemStack itemStack = player.m_21120_(event.getHand());
            if (!HardcoreRevivalConfig.getActive().allowBows || !(itemStack.m_41720_() instanceof BowItem)) {
                event.setCanceled(true);
            }
        }
    }

    public static void onUseItem(UseItemEvent event) {
        Player player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((Entity)player).isKnockedOut()) {
            ItemStack itemStack = player.m_21120_(event.getHand());
            if (!HardcoreRevivalConfig.getActive().allowBows || !(itemStack.m_41720_() instanceof BowItem)) {
                event.setCanceled(true);
            }
        }
    }

    public static void onTossItem(TossItemEvent event) {
        Player player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((Entity)player).isKnockedOut() && player.m_36356_(event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    public static void onAttack(PlayerAttackEvent event) {
        Player player = event.getPlayer();
        if (player != null && HardcoreRevival.getRevivalData((Entity)player).isKnockedOut()) {
            if (HardcoreRevivalConfig.getActive().allowUnarmedMelee && player.m_21205_().m_41619_()) {
                return;
            }
            event.setCanceled(true);
        }
    }
}

