/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.PlayerLogoutEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class LoginLogoutHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(PlayerLoginEvent.class, LoginLogoutHandler::onPlayerLogin);
        Balm.getEvents().onEvent(PlayerLogoutEvent.class, LoginLogoutHandler::onPlayerLogout);
    }

    public static void onPlayerLogin(PlayerLoginEvent event) {
        ServerPlayer player = event.getPlayer();
        CompoundTag data = Balm.getHooks().getPersistentData((Player)player);
        HardcoreRevivalData revivalData = HardcoreRevival.getRevivalData((Entity)player);
        revivalData.deserialize(data.m_128469_("HardcoreRevival"));
        if (HardcoreRevivalConfig.getActive().continueTimerWhileOffline && revivalData.isKnockedOut()) {
            long worldTimeNow = player.f_19853_.m_46467_();
            long worldTimeThen = revivalData.getLogoutWorldTime();
            int worldTimePassed = (int)Math.max(0L, worldTimeNow - worldTimeThen);
            revivalData.setKnockoutTicksPassed(revivalData.getKnockoutTicksPassed() + worldTimePassed);
        }
        HardcoreRevival.getManager().updateKnockoutEffects((Player)player);
    }

    public static void onPlayerLogout(PlayerLogoutEvent event) {
        ServerPlayer player = event.getPlayer();
        CompoundTag data = Balm.getHooks().getPersistentData((Player)player);
        HardcoreRevivalData revivalData = HardcoreRevival.getRevivalData((Entity)player);
        revivalData.setLogoutWorldTime(player.f_19853_.m_46467_());
        CompoundTag tag = revivalData.serialize();
        if (tag != null) {
            data.m_128365_("HardcoreRevival", (Tag)tag);
        }
    }
}

