/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.handler.KnockoutSyncHandler;
import net.blay09.mods.hardcorerevival.network.RevivalProgressMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class RescueHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(UseItemEvent.class, RescueHandler::onUseItem);
        Balm.getEvents().onEvent(UseBlockEvent.class, RescueHandler::onUseBlock);
        Balm.getEvents().onEvent(PlayerAttackEvent.class, RescueHandler::onAttack);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.End, RescueHandler::onPlayerTick);
    }

    public static void onUseItem(UseItemEvent event) {
        if (HardcoreRevival.getManager().isRescuing(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static void onUseBlock(UseBlockEvent event) {
        if (HardcoreRevival.getManager().isRescuing(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static void onAttack(PlayerAttackEvent event) {
        HardcoreRevival.getManager().abortRescue(event.getPlayer());
    }

    public static void onPlayerTick(ServerPlayer player) {
        HardcoreRevivalData revivalData = HardcoreRevival.getRevivalData((Entity)player);
        Player rescueTarget = revivalData.getRescueTarget();
        if (rescueTarget != null) {
            HardcoreRevivalData rescueTargetData = HardcoreRevival.getRevivalData((Entity)rescueTarget);
            int knockoutTicksPassed = rescueTargetData.getKnockoutTicksPassed();
            if (!rescueTarget.m_6084_() || knockoutTicksPassed >= HardcoreRevivalConfig.getActive().ticksUntilDeath) {
                HardcoreRevival.getManager().abortRescue((Player)player);
            } else {
                float dist = player.m_20270_((Entity)rescueTarget);
                if ((double)dist > HardcoreRevivalConfig.getActive().rescueDistance) {
                    HardcoreRevival.getManager().abortRescue((Player)player);
                } else {
                    int rescueTime = revivalData.getRescueTime() + 1;
                    revivalData.setRescueTime(rescueTime);
                    rescueTargetData.setKnockoutTicksPassed(knockoutTicksPassed - 1);
                    int maxRescueActionTicks = HardcoreRevivalConfig.getActive().rescueActionTicks;
                    int step = maxRescueActionTicks / 4;
                    if (rescueTime >= maxRescueActionTicks) {
                        HardcoreRevival.getManager().finishRescue((Player)player);
                    } else if (rescueTime % step == 0) {
                        Balm.getNetworking().sendTo((Player)player, (Object)new RevivalProgressMessage(rescueTarget.m_19879_(), (float)rescueTime / (float)maxRescueActionTicks));
                        KnockoutSyncHandler.sendHardcoreRevivalData(rescueTarget, (Entity)rescueTarget, rescueTargetData, true);
                    }
                }
            }
        }
    }
}

