/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.network;

import java.util.List;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class RescueMessage {
    private final boolean active;

    public RescueMessage(boolean active) {
        this.active = active;
    }

    public static void encode(RescueMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.active);
    }

    public static RescueMessage decode(FriendlyByteBuf buf) {
        boolean active = buf.readBoolean();
        return new RescueMessage(active);
    }

    public static void handle(ServerPlayer player, RescueMessage message) {
        if (player == null || !player.m_6084_() || player.m_5833_() || HardcoreRevival.getRevivalData((Entity)player).isKnockedOut()) {
            return;
        }
        if (message.active) {
            double range = HardcoreRevivalConfig.getActive().rescueDistance;
            List candidates = player.f_19853_.m_6443_(Player.class, player.m_20191_().m_82400_(range), p -> p != null && HardcoreRevival.getRevivalData((Entity)p).isKnockedOut());
            float minDist = Float.MAX_VALUE;
            Player target = null;
            for (Player candidate : candidates) {
                float dist = candidate.m_20270_((Entity)player);
                if (!(dist < minDist)) continue;
                target = candidate;
                minDist = dist;
            }
            if (target != null) {
                HardcoreRevival.getManager().startRescue((Player)player, target);
            }
        } else {
            HardcoreRevival.getManager().abortRescue((Player)player);
        }
    }
}

