/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.data;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.nethersdelight.NethersDelight;
import umpaz.nethersdelight.common.registry.NDItems;

public class NDItemModels
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";

    public NDItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "nethersdelight", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = ForgeRegistries.ITEMS.getValues().stream().filter(i -> "nethersdelight".equals(ForgeRegistries.ITEMS.getKey(i).m_135827_())).collect(Collectors.toSet());
        this.itemGeneratedModel((Item)NDItems.CRIMSON_FUNGUS_COLONY.get(), this.resourceBlock(this.itemName((Item)NDItems.CRIMSON_FUNGUS_COLONY.get()) + "_stage3"));
        items.remove(NDItems.CRIMSON_FUNGUS_COLONY.get());
        this.itemGeneratedModel((Item)NDItems.WARPED_FUNGUS_COLONY.get(), this.resourceBlock(this.itemName((Item)NDItems.WARPED_FUNGUS_COLONY.get()) + "_stage3"));
        items.remove(NDItems.WARPED_FUNGUS_COLONY.get());
        NDItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        HashSet handheldItems = Sets.newHashSet();
        NDItemModels.takeAll(items, handheldItems.toArray(new Item[0])).forEach(item -> this.itemHandheldModel((Item)item, this.resourceItem(this.itemName((Item)item))));
        items.forEach(item -> this.itemGeneratedModel((Item)item, this.resourceItem(this.itemName((Item)item))));
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    public void itemHandheldModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), HANDHELD)).texture("layer0", texture);
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", texture);
    }

    private String itemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("nethersdelight", "block/" + path);
    }

    public ResourceLocation resourceItem(String path) {
        return new ResourceLocation("nethersdelight", "item/" + path);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            NethersDelight.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            NethersDelight.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            NethersDelight.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }
}

