/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import dev.yurisuika.raised.server.command.RaisedCommand;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import net.minecraft.client.KeyMapping;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="raised")
public class Raised {
    public static File file = new File(FMLPaths.CONFIGDIR.get().toFile(), "raised.json");
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static Config config = new Config();
    public static final KeyMapping hudDown = new KeyMapping("key.raised.hud.down", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 333, "key.categories.raised");
    public static final KeyMapping hudUp = new KeyMapping("key.raised.hud.up", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 334, "key.categories.raised");
    public static final KeyMapping chatDown = new KeyMapping("key.raised.chat.down", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 331, "key.categories.raised");
    public static final KeyMapping chatUp = new KeyMapping("key.raised.chat.up", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 332, "key.categories.raised");

    public static void saveConfig() {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)Raised.getConfig()));
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig() {
        try {
            config = file.exists() ? (Config)gson.fromJson(Files.readString(file.toPath()), Config.class) : new Config();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Raised.setConfig(config);
    }

    public static void setConfig(Config config) {
        Raised.config = config;
    }

    public static Config getConfig() {
        return config;
    }

    public static void setHud(int value) {
        Raised.config.hud = value;
        Raised.saveConfig();
    }

    public static void setChat(int value) {
        Raised.config.chat = value;
        Raised.saveConfig();
    }

    public static int getHud() {
        return Raised.config.hud;
    }

    public static int getChat() {
        return Raised.config.chat;
    }

    public Raised() {
        if (!file.exists()) {
            Raised.saveConfig();
        }
        Raised.loadConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static class Config {
        public int hud = 2;
        public int chat = 0;
    }

    @Mod.EventBusSubscriber(modid="raised", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(hudDown);
            event.register(hudUp);
            event.register(chatDown);
            event.register(chatUp);
        }
    }

    @Mod.EventBusSubscriber(modid="raised", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void keyInput(InputEvent.Key event) {
            if (hudDown.m_90859_()) {
                Raised.setHud(Raised.config.hud - 1);
            }
            if (hudUp.m_90859_()) {
                Raised.setHud(Raised.config.hud + 1);
            }
            if (chatDown.m_90859_()) {
                Raised.setChat(Raised.config.chat - 1);
            }
            if (chatUp.m_90859_()) {
                Raised.setChat(Raised.config.chat + 1);
            }
        }

        @SubscribeEvent
        public static void registerClientCommands(RegisterClientCommandsEvent event) {
            RaisedCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        }
    }
}

