/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized;

import com.google.common.collect.ImmutableBiMap;
import com.redlimerl.detailab.api.DetailArmorBarAPI;
import com.redlimerl.detailab.api.render.ArmorBarRenderManager;
import com.redlimerl.detailab.api.render.TextureOffset;
import galena.oreganized.client.OreganizedClient;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import galena.oreganized.data.OAdvancements;
import galena.oreganized.data.OBiomeTags;
import galena.oreganized.data.OBlockStates;
import galena.oreganized.data.OBlockTags;
import galena.oreganized.data.OEntityTags;
import galena.oreganized.data.OFluidTags;
import galena.oreganized.data.OItemModels;
import galena.oreganized.data.OItemTags;
import galena.oreganized.data.OLang;
import galena.oreganized.data.OLootTables;
import galena.oreganized.data.OPaintingVariantTags;
import galena.oreganized.data.ORecipes;
import galena.oreganized.data.OSoundDefinitions;
import galena.oreganized.data.modifiers.OBiomeModifier;
import galena.oreganized.index.OBlockEntities;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OFeatures;
import galena.oreganized.index.OFluids;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OPaintingVariants;
import galena.oreganized.index.OParticleTypes;
import galena.oreganized.index.OPotions;
import galena.oreganized.index.OSoundEvents;
import galena.oreganized.index.OStructures;
import galena.oreganized.integration.CompatHandler;
import galena.oreganized.integration.CompatHandlerClient;
import java.util.Map;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="oreganized")
public class Oreganized {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "oreganized";

    public static ResourceLocation modLoc(String location) {
        return new ResourceLocation(MOD_ID, location);
    }

    public Oreganized() {
        DeferredRegister[] registers;
        IEventBus bus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        ModLoadingContext context = ModLoadingContext.get();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::gatherData);
        for (DeferredRegister register : registers = new DeferredRegister[]{OBlockEntities.BLOCK_ENTITIES, OBlocks.BLOCKS, OEffects.EFFECTS, OEntityTypes.ENTITIES, OFluids.FLUIDS, OFluids.TYPES, OItems.ITEMS, OParticleTypes.PARTICLES, OPotions.POTIONS, OSoundEvents.SOUNDS, OStructures.STRUCTURES, OFeatures.FEATURES, OFeatures.Configured.CONFIGURED_FEATURES, OFeatures.Placed.PLACED_FEATURES, OPaintingVariants.PAINTING_VARIANTS}) {
            register.register(bus);
        }
        CompatHandler.register();
    }

    private void setup(FMLCommonSetupEvent event) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)OFluids.MOLTEN_LEAD_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> ((Block)OBlocks.LEAD_BLOCK.get()).m_49966_()));
        event.enqueueWork(() -> {
            Map EMPTY = CauldronInteraction.f_175606_;
            Map WATER = CauldronInteraction.f_175607_;
            Map LAVA = CauldronInteraction.f_175608_;
            Map POWDER_SNOW = CauldronInteraction.f_175609_;
            Map<Item, CauldronInteraction> LEAD = MoltenLeadCauldronBlock.INTERACTION_MAP;
            EMPTY.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            WATER.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            LAVA.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            POWDER_SNOW.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            LEAD.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            EMPTY.put(((Block)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
            WATER.put(((Block)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
            LAVA.put(((Block)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
            POWDER_SNOW.put(((Block)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
            LEAD.put(Items.f_41852_, MoltenLeadCauldronBlock.EMPTY_LEAD_BLOCK);
            LEAD.put(Items.f_42446_, MoltenLeadCauldronBlock.EMPTY_MOLTEN_LEAD);
            CauldronInteraction.m_175647_(MoltenLeadCauldronBlock.INTERACTION_MAP);
            PotionBrewing.m_43513_((Potion)Potions.f_43599_, (Item)((Item)OItems.LEAD_INGOT.get()), (Potion)((Potion)OPotions.STUNNING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)OPotions.STUNNING.get()), (Item)Items.f_42451_, (Potion)((Potion)OPotions.LONG_STUNNING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)OPotions.STUNNING.get()), (Item)Items.f_42525_, (Potion)((Potion)OPotions.STRONG_STUNNING.get()));
            FireBlock fire = (FireBlock)Blocks.f_50083_;
            fire.m_53444_((Block)OBlocks.SHRAPNEL_BOMB.get(), 15, 100);
        });
        OBlocks.WAXED_BLOCKS = new ImmutableBiMap.Builder().put((Object)((Block)OBlocks.WAXED_SPOTTED_GLANCE.get()), (Object)((Block)OBlocks.SPOTTED_GLANCE.get())).put((Object)((Block)OBlocks.WAXED_WHITE_CONCRETE_POWDER.get()), (Object)Blocks.f_50506_).put((Object)((Block)OBlocks.WAXED_ORANGE_CONCRETE_POWDER.get()), (Object)Blocks.f_50507_).put((Object)((Block)OBlocks.WAXED_MAGENTA_CONCRETE_POWDER.get()), (Object)Blocks.f_50508_).put((Object)((Block)OBlocks.WAXED_LIGHT_BLUE_CONCRETE_POWDER.get()), (Object)Blocks.f_50509_).put((Object)((Block)OBlocks.WAXED_YELLOW_CONCRETE_POWDER.get()), (Object)Blocks.f_50510_).put((Object)((Block)OBlocks.WAXED_LIME_CONCRETE_POWDER.get()), (Object)Blocks.f_50511_).put((Object)((Block)OBlocks.WAXED_PINK_CONCRETE_POWDER.get()), (Object)Blocks.f_50512_).put((Object)((Block)OBlocks.WAXED_GRAY_CONCRETE_POWDER.get()), (Object)Blocks.f_50513_).put((Object)((Block)OBlocks.WAXED_LIGHT_GRAY_CONCRETE_POWDER.get()), (Object)Blocks.f_50514_).put((Object)((Block)OBlocks.WAXED_CYAN_CONCRETE_POWDER.get()), (Object)Blocks.f_50515_).put((Object)((Block)OBlocks.WAXED_PURPLE_CONCRETE_POWDER.get()), (Object)Blocks.f_50516_).put((Object)((Block)OBlocks.WAXED_BLUE_CONCRETE_POWDER.get()), (Object)Blocks.f_50517_).put((Object)((Block)OBlocks.WAXED_BROWN_CONCRETE_POWDER.get()), (Object)Blocks.f_50518_).put((Object)((Block)OBlocks.WAXED_GREEN_CONCRETE_POWDER.get()), (Object)Blocks.f_50519_).put((Object)((Block)OBlocks.WAXED_RED_CONCRETE_POWDER.get()), (Object)Blocks.f_50573_).put((Object)((Block)OBlocks.WAXED_BLACK_CONCRETE_POWDER.get()), (Object)Blocks.f_50574_).build();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CompatHandlerClient.setup(event);
        OreganizedClient.registerBlockRenderers();
        ItemProperties.register((Item)((Item)OItems.SILVER_MIRROR.get()), (ResourceLocation)new ResourceLocation("level"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 8.0f;
            }
            return stack.m_41784_().m_128451_("Level");
        });
        if (ModList.get().isLoaded("detailab")) {
            ResourceLocation texture = Oreganized.modLoc("textures/gui/armor_bar.png");
            DetailArmorBarAPI.customArmorBarBuilder().armor(new ArmorItem[]{(ArmorItem)OItems.ELECTRUM_CHESTPLATE.get(), (ArmorItem)OItems.ELECTRUM_HELMET.get(), (ArmorItem)OItems.ELECTRUM_LEGGINGS.get(), (ArmorItem)OItems.ELECTRUM_BOOTS.get()}).render(itemStack -> new ArmorBarRenderManager(texture, 18, 18, new TextureOffset(9, 9), new TextureOffset(0, 9), new TextureOffset(9, 0), new TextureOffset(0, 0))).register();
        }
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        generator.m_236039_(client, (DataProvider)new OBlockStates(generator, helper));
        generator.m_236039_(client, (DataProvider)new OItemModels(generator, helper));
        generator.m_236039_(client, (DataProvider)new OLang(generator));
        generator.m_236039_(client, (DataProvider)new OSoundDefinitions(generator, helper));
        generator.m_236039_(server, (DataProvider)new ORecipes(generator));
        generator.m_236039_(server, (DataProvider)new OLootTables(generator));
        OBlockTags blockTags = new OBlockTags(generator, helper);
        generator.m_236039_(server, (DataProvider)blockTags);
        generator.m_236039_(server, (DataProvider)new OItemTags(generator, blockTags, helper));
        generator.m_236039_(server, (DataProvider)new OEntityTags(generator, helper));
        generator.m_236039_(server, (DataProvider)new OAdvancements(generator, helper));
        generator.m_236039_(server, (DataProvider)new OFluidTags(generator, helper));
        generator.m_236039_(server, (DataProvider)new OBiomeTags(generator, helper));
        generator.m_236039_(server, (DataProvider)new OPaintingVariantTags(generator, helper));
        generator.m_236039_(server, OBiomeModifier.register(event));
    }
}

