/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="oreganized")
public class OreganizedConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        Pair cleintSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        COMMON = (Common)commonSpecPair.getLeft();
        CLIENT = (Client)cleintSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        CLIENT_SPEC = (ForgeConfigSpec)cleintSpecPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> leadClusterSize;
        public final ForgeConfigSpec.ConfigValue<Integer> leadFrequency;
        public final ForgeConfigSpec.ConfigValue<Integer> leadMinHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> leadMaxHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> silverClusterSize;
        public final ForgeConfigSpec.ConfigValue<Integer> silverFrequency;
        public final ForgeConfigSpec.ConfigValue<Integer> silverMinHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> silverMaxHeight;
        public final ForgeConfigSpec.ConfigValue<Boolean> ravagerSilver;

        private Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common");
            builder.push("common");
            builder.comment("Lead");
            builder.push("lead");
            this.leadClusterSize = builder.comment("The average cluster size lead ore generates in").define("leadClusterSize", (Object)6);
            this.leadFrequency = builder.comment("How frequent lead ore generates").define("leadFrequency", (Object)6);
            this.leadMinHeight = builder.comment("Minimum y level that lead ore can generate").define("leadMinHeight", (Object)-40);
            this.leadMaxHeight = builder.comment("Maximum y level that lead ore can generate").define("leadMaxHeight", (Object)-20);
            builder.comment("Silver");
            builder.push("silver");
            this.silverClusterSize = builder.comment("The average cluster size silver ore generates in").define("silverClusterSize", (Object)6);
            this.silverFrequency = builder.comment("How frequent silver ore generates").define("silverFrequency", (Object)6);
            this.silverMinHeight = builder.comment("Minimum y level that silver ore can generate").define("silverMinHeight", (Object)-15);
            this.silverMaxHeight = builder.comment("Maximum y level that silver ore can generate").define("silverMaxHeight", (Object)5);
            this.ravagerSilver = builder.comment("Ravagers have a chance of dropping Silver Nuggets upon death").define("ravagerSilver", true);
            builder.pop();
        }
    }

    public static class Client {
        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client");
            builder.push("client");
            builder.pop();
        }
    }
}

