/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MoltenLeadBlock
extends LiquidBlock {
    private static final BooleanProperty MOVING = BooleanProperty.m_61465_((String)"moving");
    public static final VoxelShape STABLE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public MoltenLeadBlock(Supplier<? extends FlowingFluid> fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties.m_60910_().m_60913_(-1.0f, 3600000.0f).m_222994_().m_60953_(state -> 8));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MOVING});
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState neighbour, LevelAccessor pLevel, BlockPos pPos, BlockPos neighbourPos) {
        if (pDirection == Direction.DOWN) {
            pLevel.m_186460_(pPos, (Block)this, 30);
        }
        return super.m_7417_(pState, pDirection, neighbour, pLevel, pPos, neighbourPos);
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.WALKABLE;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pIsMoving) {
            if (!pOldState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                this.scheduleFallingTick((LevelAccessor)pLevel, pPos, 30);
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)MOVING, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                pLevel.m_46796_(1501, pPos, 0);
                pLevel.m_7731_(pPos, ((Block)OBlocks.LEAD_BLOCK.get()).m_49966_(), 3);
            }
        } else if (!pOldState.m_60819_().m_205070_(FluidTags.f_13131_)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)MOVING, (Comparable)Boolean.valueOf(false)), 3);
            pLevel.m_186460_(pPos, (Block)this, 300);
        } else {
            pLevel.m_46796_(1501, pPos, 0);
            pLevel.m_7731_(pPos, ((Block)OBlocks.LEAD_BLOCK.get()).m_49966_(), 3);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.m_8055_(pPos.m_7495_()).m_60734_() == Blocks.f_50016_ || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_198158_) || pLevel.m_8055_(pPos.m_7495_()).m_60819_().m_205070_(FluidTags.f_13131_) || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_13037_) || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_13040_)) {
            pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 67);
            pLevel.m_7731_(pPos.m_7495_(), ((LiquidBlock)OBlocks.MOLTEN_LEAD.get()).m_49966_(), 67);
        }
    }

    private boolean scheduleFallingTick(LevelAccessor pLevel, BlockPos pPos, int pDelay) {
        if (pLevel.m_8055_(pPos.m_7495_()).m_60734_() == Blocks.f_50016_ || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_198158_) || pLevel.m_8055_(pPos.m_7495_()).m_60819_().m_205070_(FluidTags.f_13131_) || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_13037_) || pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_13040_)) {
            pLevel.m_186460_(pPos, (Block)this, pDelay);
            return true;
        }
        return false;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext ctx) {
        EntityCollisionContext eCtx;
        if (ctx instanceof EntityCollisionContext && (eCtx = (EntityCollisionContext)ctx).m_193113_() != null) {
            return ctx.m_6513_(STABLE_SHAPE, blockPos, true) && (Integer)blockState.m_61143_((Property)f_54688_) == 0 && MoltenLeadBlock.isEntityLighterThanLead(eCtx.m_193113_()) ? STABLE_SHAPE : Shapes.m_83040_();
        }
        return super.m_5939_(blockState, world, blockPos, ctx);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockWorld, BlockPos pos, CollisionContext context) {
        if (context.m_7142_((Item)OItems.MOLTEN_LEAD_BUCKET.get())) {
            return blockWorld.m_8055_(pos.m_7494_()) != state ? STABLE_SHAPE : Shapes.m_83144_();
        }
        return Shapes.m_83040_();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return state.m_60713_(Blocks.f_49991_);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.m_20186_() < (double)pos.m_123342_() + STABLE_SHAPE.m_83297_(Direction.Axis.Y)) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || entity.m_146900_().m_60713_((Block)this)) {
                entity.m_7601_(state, new Vec3((double)0.9f, 1.0, (double)0.9f));
            }
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6117_() && living.m_21212_() == 0 && living.m_21120_(living.m_7655_()).m_41614_()) {
                living.m_7292_(new MobEffectInstance((MobEffect)OEffects.STUNNING.get(), 800));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200));
            }
            entity.m_20254_(10);
            if (!world.f_46443_) {
                entity.m_146868_(true);
            }
        }
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!((double)fallDistance < 4.0) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            LivingEntity.Fallsounds fallSound = living.m_196493_();
            SoundEvent sound = (double)fallDistance < 7.0 ? fallSound.f_196626_() : fallSound.f_196627_();
            entity.m_5496_(sound, 1.0f, 1.0f);
        }
    }

    public static boolean isEntityLighterThanLead(Entity entity) {
        if (entity.m_6095_().m_204039_(OTags.Entities.LIGHTER_THAN_LEAD)) {
            return true;
        }
        return entity instanceof LivingEntity && ((LivingEntity)entity).m_6844_(EquipmentSlot.FEET).m_204117_(OTags.Items.LIGHTER_THAN_LEAD);
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.of(SoundEvents.f_11783_);
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType pathFinder) {
        return true;
    }
}

