/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import galena.oreganized.client.model.ElectrumArmorModel;
import galena.oreganized.content.item.OItem;
import galena.oreganized.index.OArmorMaterials;
import galena.oreganized.index.OItems;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ElectrumArmorItem
extends ArmorItem {
    private static final String TEXTURE = "oreganized:textures/entity/electrum_armor.png";

    public ElectrumArmorItem(ArmorMaterial material, EquipmentSlot slot) {
        super(material, slot, new Item.Properties().m_41491_(CreativeModeTab.f_40757_));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == this.f_40377_) {
            UUID uuid = f_40380_[slot.m_20749_()];
            return ImmutableMultimap.of((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Electrum speed", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)OArmorMaterials.ELECTRUM.m_7365_(this.f_40377_), AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)OArmorMaterials.ELECTRUM.m_6651_(), AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)OArmorMaterials.ELECTRUM.m_6649_(), AttributeModifier.Operation.ADDITION));
        }
        return super.m_7167_(slot);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return new ElectrumArmorModel(ElectrumArmorModel.createBodyLayer().m_171564_(), armorSlot);
            }
        });
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            OItem.insert(new ItemStack((ItemLike)this), false, items, stack -> {
                Item item = stack.m_41720_();
                Item piece = this.m_5456_();
                return piece == OItems.ELECTRUM_HELMET.get() && item == Items.f_42483_ || piece == OItems.ELECTRUM_CHESTPLATE.get() && item == OItems.ELECTRUM_HELMET.get() || piece == OItems.ELECTRUM_LEGGINGS.get() && item == OItems.ELECTRUM_CHESTPLATE.get() || piece == OItems.ELECTRUM_BOOTS.get() && item == OItems.ELECTRUM_LEGGINGS.get();
            });
        }
    }
}

