/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import galena.oreganized.data.provider.OBlockLootProvider;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OItems;
import galena.oreganized.integration.quark.QCompatRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class OLootTables
extends LootTableProvider {
    public OLootTables(DataGenerator gen) {
        super(gen);
    }

    public String m_6055_() {
        return "Oreganized Loot Tables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(Entities::new, (Object)LootContextParamSets.f_81415_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext tracker) {
    }

    public static class Entities
    extends EntityLoot {
        protected void addTables() {
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return OEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }

    public static class Blocks
    extends OBlockLootProvider {
        protected void addTables() {
            this.cauldron((Supplier<? extends Block>)OBlocks.MOLTEN_LEAD_CAULDRON);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE);
            this.dropSelf((Supplier<? extends Block>)OBlocks.POLISHED_GLANCE);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_BRICKS);
            this.dropSelf((Supplier<? extends Block>)OBlocks.CHISELED_GLANCE);
            this.slab((Supplier<? extends Block>)OBlocks.GLANCE_SLAB);
            this.slab((Supplier<? extends Block>)OBlocks.POLISHED_GLANCE_SLAB);
            this.slab((Supplier<? extends Block>)OBlocks.GLANCE_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)OBlocks.POLISHED_GLANCE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_WALL);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)OBlocks.SPOTTED_GLANCE);
            this.dropSelf((Supplier<? extends Block>)OBlocks.WAXED_SPOTTED_GLANCE);
            this.ore((Supplier<? extends Block>)OBlocks.SILVER_ORE, (Supplier<? extends Item>)OItems.RAW_SILVER);
            this.ore((Supplier<? extends Block>)OBlocks.DEEPSLATE_SILVER_ORE, (Supplier<? extends Item>)OItems.RAW_SILVER);
            this.ore((Supplier<? extends Block>)OBlocks.LEAD_ORE, (Supplier<? extends Item>)OItems.RAW_LEAD);
            this.ore((Supplier<? extends Block>)OBlocks.DEEPSLATE_LEAD_ORE, (Supplier<? extends Item>)OItems.RAW_LEAD);
            this.dropSelf((Supplier<? extends Block>)OBlocks.RAW_SILVER_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.RAW_LEAD_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.SILVER_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.LEAD_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.ELECTRUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.EXPOSER);
            this.dropSelf((Supplier<? extends Block>)OBlocks.SHRAPNEL_BOMB);
            this.dropSelf((Supplier<? extends Block>)QCompatRegistry.GLANCE_PILLAR);
            this.slab((Supplier<? extends Block>)QCompatRegistry.RAW_LEAD_BRICK_SLAB);
            this.slab((Supplier<? extends Block>)QCompatRegistry.RAW_SILVER_BRICK_SLAB);
            this.slab((Supplier<? extends Block>)QCompatRegistry.GLANCE_VERTICAL_SLAB);
            this.slab((Supplier<? extends Block>)QCompatRegistry.POLISHED_GLANCE_VERTICAL_SLAB);
            this.slab((Supplier<? extends Block>)QCompatRegistry.GLANCE_BRICK_VERTICAL_SLAB);
            for (int i = 0; OBlocks.CRYSTAL_GLASS.size() > i; ++i) {
                this.dropAsSilk((Supplier)OBlocks.CRYSTAL_GLASS.get(i));
                this.dropAsSilk((Supplier)OBlocks.CRYSTAL_GLASS_PANES.get(i));
            }
            for (Supplier supplier : OBlocks.WAXED_CONRETE_POWDER) {
                this.dropSelf(supplier);
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return OBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

